package ru.yandex.autotests.directapi.finance.paycampaigns;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 16.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS)
public class MethodAvailabilityTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String agencyLogin = Logins.AGENCY_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    public void methodPayCampaignsNotAvailableInV4() {
        api.version(4).userSteps.financeSteps().shouldGetErrorOnPayCampaigns(new AxisError(509),
                new PayCampaignsInfoMap(api.type()));
    }
}
