package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.lowerCase;

/**
 * Author pavryabov
 * Date 16.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS)
@RunWith(Parameterized.class)
public class PayCampaigns4VersionInvalidMethodsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = FinanceLogins.FREE_CLIENT_OVERDRAFT2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String payMethod;

    @Parameterized.Parameter(value = 1)
    public int version;

    @Parameterized.Parameter(value = 2)
    public AxisErrorDetails errorDetails;

    @Parameterized.Parameters(name = "Method = {0}, Version = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][] {
                {lowerCase(PayMethod.YM), 104, AxisErrorDetails.FIELD_PAYMETHOD_ALLOWED_VALUE_BANK_OVERDRAFT},
                {lowerCase(PayMethod.OVERDRAFT), 104, AxisErrorDetails.FIELD_PAYMETHOD_ALLOWED_VALUE_BANK_OVERDRAFT},
                {lowerCase(PayMethod.BANK), 104, AxisErrorDetails.FIELD_PAYMETHOD_ALLOWED_VALUE_BANK_OVERDRAFT}
        };
        return Arrays.asList(data);
    }

    private static float sum = MoneyCurrency.get(null).getMinInvoiceAmount().floatValue();
    private static long campaignID;

    @BeforeClass
    public static void createCampaigns() {
        campaignID = api.userSteps.addActiveCampaign(clientLogin, 1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6365")
    public void payCampaignWithInvalidMethodWithFinanceToken() {
        api.version(version).userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(71, errorDetails),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(payMethod)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum)));
    }

    //@Test до починки ЯД DIRECT-65926
    @ru.yandex.qatools.allure.annotations.TestCaseId("6366")
    public void payCampaignWithInvalidMethodWithPaymentToken() {
        api.version(version).userSteps.financeSteps().shouldGetErrorOnPayCampaignsYM(
                new AxisError(71, errorDetails),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(payMethod)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum)));
    }
}
