package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.math.RoundingMode;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Author pavryabov
 * Date 24.05.14
 * https://jira.yandex-team.ru/browse/TESTIRT-513
 */
@Aqua.Test
@Feature(FinanceFeatures.PAY_CAMPAIGNS)
@Stories(ApiStories.CURRENCY)
public class PayCampaignsCurrencyFieldTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String noCurrencyAgency = Logins.AGENCY_YE_DEFAULT;
    private static String noCurrencyClient = Logins.CLIENT_FREE_YE_DEFAULT;
    private static String rubAgency = Logins.AGENCY_RUB;
    private static String rubClient = Logins.SUBCLIENT_RUB;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6390")
    public void expectErrorPayCampaignsNoCurrencyClientRUBInRequest() {
        api.as(noCurrencyAgency);
        long campaignID = api.userSteps.addActiveCampaign(noCurrencyClient, 1);
        float sum = MoneyCurrency.get(null).getMinInvoiceAmount().floatValue();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(noCurrencyAgency).getClientID(), 2);
        log.info("Вызываем метод PayCampaigns для кампании невалютного клиента с параметром Currency = RUB");
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(245, AxisErrorDetails.NO_VALID_CURRENCY_VALUE),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum)
                                .withCurrency(Currency.RUB)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6392")
    public void payCampaignsRUBClientRUBInRequest() {
        api.as(rubAgency);
        long campaignID = api.userSteps.addActiveCampaign(rubClient, 1);
        float sum = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount()
                .addVAT().setScale(2, RoundingMode.HALF_UP).floatValue();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(rubAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для кампании рублевого клиента с параметром Currency = RUB");
        int response = api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum)
                        .withCurrency(Currency.RUB));
        assertThat("Метод вернул ошибку", response, equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6393")
    public void expectErrorPayCampaignsRUBClientUSDInRequest() {
        api.as(rubAgency);
        long campaignID = api.userSteps.addActiveCampaign(rubClient, 1);
        float sum = MoneyCurrency.get(Currency.USD).getMinInvoiceAmount()
                .addVAT().setScale(2, RoundingMode.HALF_UP).floatValue();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(rubAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для кампании невалютного клиента с параметром Currency = USD");
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.RUB),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum)
                                .withCurrency(Currency.USD)));
    }
}
