package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.math.RoundingMode;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 25.05.14
 * https://jira.yandex-team.ru/browse/TESTIRT-513
 */
@Aqua.Test
@Feature(FinanceFeatures.PAY_CAMPAIGNS)
@Stories(ApiStories.CURRENCY)
public class PayCampaignsCurrencyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String noCurrencyAgency = Logins.AGENCY_YE_DEFAULT;
    private static String noCurrencyClient = Logins.CLIENT_FREE_YE_DEFAULT;
    private static String rubAgency = Logins.AGENCY_RUB;
    private static String rubClient = Logins.SUBCLIENT_RUB;
    private static String uahAgency = Logins.AGENCY_UAH;
    private static String uahClient = Logins.SUBCLIENT_UAH;
    private static String eurAgency = Logins.AGENCY_EUR;
    private static String eurClient = Logins.SUBCLIENT_EUR;
    private static String bynAgency = Logins.BYN_AGENCY2;
    private static String bynClient = Logins.BYN_SUBCLIENT2;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6395")
    public void payCampaignsRUBClientRUBInRequest() {
        api.as(rubAgency);
        long campaignID = api.userSteps.addActiveCampaign(rubClient, 1);
        Money sum = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(rubAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для рублевого клиента. Currency = RUB");
        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaign(rubClient, campaignID);
        api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum.addVAT().floatValue())
                        .withCurrency(Currency.RUB));
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(rubClient, campaign, sum));
    }

/* DIRECT-66511
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6397")
    public void payCampaignsUAHClientNoCurrencyInRequest() {
        api.as(uahAgency);
        long campaignID = api.userSteps.addActiveCampaign(uahClient, 1);
        Money sum = MoneyCurrency.get(Currency.UAH).getMinInvoiceAmount()
                .convert(null).setScale(RoundingMode.UP);
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(uahAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для украинского клиента. Currency = null");
        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaign(uahClient, campaignID);
        api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum.floatValue())
                        .withCurrency((String) null));
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(
                        uahClient, campaign,
                        sum.convert(Currency.UAH).setScale(2, RoundingMode.UP)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6398")
    public void payCampaignsUAHClientUAHInRequest() {
        api.as(uahAgency);
        long campaignID = api.userSteps.addActiveCampaign(uahClient, 1);
        Money sum = MoneyCurrency.get(Currency.UAH).getMinInvoiceAmount();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(uahAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для украинского клиента. Currency = UAH");
        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaign(uahClient, campaignID);
        api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum.addVAT().floatValue())
                        .withCurrency(Currency.UAH));
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(uahClient, campaign, sum));
    }
*/

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6399")
    /*
    У агентства для данного теста в Балансе должны быть следующие сущности:
    Плательщик - Нерезидент, Швейцария
    Договор - Швейцария: Оптовый агентский, оплата в EUR
    Немного истории - https://st.yandex-team.ru/DIRECT-66164
     */
    public void payCampaignsEURClientEURInRequest() {
        api.as(eurAgency);
        long campaignID = api.userSteps.addActiveCampaign(eurClient, 1);
        Money sum = MoneyCurrency.get(Currency.EUR).getMinInvoiceAmount();
        String contract = api.userSteps.balanceSteps().getDefaultContract(User.get(eurAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для нерезидента Швейцарии. Currency = EUR");
        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaign(eurClient, campaignID);
        api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum.addVAT().floatValue())
                        .withCurrency(Currency.EUR));
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(eurClient, campaign, sum));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6400")
    public void payCampaignsRUBClientForUSDCurrencyAndRUBInRequest() {
        api.as(rubAgency);
        long campaignIDRUB = api.userSteps.addActiveCampaign(rubClient, 1);
        long campaignIDRUBElse = api.userSteps.addActiveCampaign(rubClient, 1);
        float sumRUB = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue();
        float sumUsdCurrency = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount()
                .convert(Currency.USD).setScale(RoundingMode.UP).floatValue();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(rubAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для кампаний рублевого клиента. Для одной кампании Currency = RUB, " +
                "для второй Currency = null");
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(245, AxisErrorDetails.ALL_AMOUNTS_MUST_BE_IN_THE_SAME_CURRENCY),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                        .withCampaignID(campaignIDRUB)
                                        .withSum(sumRUB)
                                        .withCurrency(Currency.RUB),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignIDRUBElse)
                                        .withSum(sumUsdCurrency)
                                        .withCurrency(Currency.USD)));
    }

    @Test
    public void payCampaignsBYNClientBYNInRequest() {
        api.as(bynAgency);
        long campaignID = api.userSteps.addActiveCampaign(bynClient, 1);
        Money sum = MoneyCurrency.get(Currency.BYN).getMinInvoiceAmount();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(bynAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для белорусского клиента. Currency = BYN");
        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaign(bynClient, campaignID);
        api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum.addVAT().floatValue())
                        .withCurrency(Currency.BYN));
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(bynClient, campaign, sum));
    }
}
