package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(FinanceFeatures.PAY_CAMPAIGNS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class PayCampaignsForNonTextCampaignTest {

    private static final String AGENCY_RUB = Logins.AGENCY_RUB;
    private static final String SUBCLIENT_RUB = Logins.SUBCLIENT_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long nonTextCampaignId;
    private static long textCampaignId;
    private static String contract;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;
    private CampaignGetItem campaign;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE},
                {CampaignsType.DYNAMIC},
                {CampaignsType.CPM_BANNER},
                {CampaignsType.CPM_DEALS},
        });
    }

    @BeforeClass
    @SuppressWarnings("Duplicates")
    public static void createNonTextAndTextCampaigns() {
        api.version(104).as(AGENCY_RUB);
        nonTextCampaignId = api.userSteps.addActiveCampaign(SUBCLIENT_RUB, 1);
        textCampaignId = api.userSteps.addActiveCampaign(SUBCLIENT_RUB, 1);
        api.userSteps.campaignFakeSteps().makeCampaignModerated(textCampaignId);
        contract = api.userSteps.balanceSteps().getDefaultContract(User.get(AGENCY_RUB).getClientID(), 1);
    }

    @Before
    public void setType() {
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, CampaignsType.TEXT);
        campaign = api.userSteps.campaignSteps().getCampaign(SUBCLIENT_RUB, nonTextCampaignId);
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6405")
    public void payCampaignsOfNonTextCampaign() {
        Money sum = Money.valueOf(2000f, Currency.RUB);
        int result = api.userSteps.financeSteps().payCampaignsBank(
                contract,
                new PayCampElementMap(api.type())
                        .withCampaignID(nonTextCampaignId)
                        .withCurrency(Currency.RUB)
                        .withSum(sum.addVAT().floatValue())
        );
        assertThat("вернулся верный ответ", result, equalTo(1));
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, CampaignsType.TEXT);
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChangedOnFunds(SUBCLIENT_RUB, campaign, sum));
    }

    @Issue("DIRECT-44427")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6406")
    public void payCampaignsOfNonTextAndTextCampaign() {
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(366),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaignId)
                                        .withCurrency(Currency.RUB)
                                        .withSum(2000f),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(textCampaignId)
                                        .withCurrency(Currency.RUB)
                                        .withSum(3000f)
                        )
        );
    }
}
