package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 30.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1452
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS)
@RunWith(Parameterized.class)
public class PayCampaignsNegativeShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public String operatorForCreateCampaign;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.CLIENT_FREE_YE_DEFAULT, Logins.AGENCY_YE_DEFAULT},
                {Logins.AGENCY_YE_DEFAULT, Logins.SUBCLIENT_SHARD, Logins.AGENCY_SHARD_2}
        };
        return Arrays.asList(data);
    }

    public long campaignID;
    public Currency currency = null;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    @SuppressWarnings("Duplicates")
    public void initTest() {
        api.as(Logins.SUPER_LOGIN, operatorForCreateCampaign);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        String[] currencyString =
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client)).getClientCurrencies();
        if (currencyString != null) {
            currency = Currency.getFor(currencyString[0]);
        } else {
            currency = Currency.RUB;
        }
        api.as(Logins.SUPER_LOGIN, operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6409")
    public void payCampaignsTest() {
        Money sum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT();
        User user = User.get(operator);
        user.resetBalanceContractInfos();
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(54),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(user.getExternalContractID())
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(currency)
                                .withSum(sum.floatValue())));
    }
}
