package ru.yandex.autotests.directapi.finance.paycampaigns;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 22.04.14
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class PayCampaignsOverdraftTestFailed {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = FinanceLogins.OLD_OVERDRAFT_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static float sum = MoneyCurrency.get(null).getMinInvoiceAmount().floatValue();
    protected static long activeCampaignID1;
    protected static long activeCampaignID2;
    protected static long deletedCampaignID;
    protected static long draftCampaignID;
    protected static long moderatedCampaignID;

    @BeforeClass
    public static void initTest() {
        activeCampaignID1 = api.userSteps.addActiveCampaign(clientLogin, 10f, null);
        activeCampaignID2 = api.userSteps.addActiveCampaign(clientLogin, 1);
        moderatedCampaignID = api.userSteps.addModeratedCampaign(clientLogin);
        draftCampaignID = api.userSteps.addDraftCampaign(clientLogin);
        deletedCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
    }

    @Test
    @Title("Bug DIRECT-30929")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6432")
    public void testPayDraftAndActiveCampaign() {
        //DIRECT-30929
        log.info("Попытка оплаты черновика вместе с активной кампанией");
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(354, AxisErrorDetails.CAMPAIGN_NOT_MODERATED, draftCampaignID),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.OVERDRAFT)
                        .withPayments(new PayCampElementMap(api.type())
                                        .withCampaignID(draftCampaignID)
                                        .withSum(sum),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(activeCampaignID2)
                                        .withSum(sum))
        );
    }
}
