package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.PayCampElement;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 30.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1452
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS)
@RunWith(Parameterized.class)
public class PayCampaignsPositiveShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public Currency currency;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.SUBCLIENT_SHARD, Currency.RUB},
                {Logins.AGENCY_SHARD_2, Logins.SUBCLIENT_SHARD_1, Currency.RUB},
        };
        return Arrays.asList(data);
    }

    public long campaignID;
    public CampaignGetItem campaign;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD_1, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void initTest() {
        api.as(Logins.SUPER_LOGIN, operator);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        campaign = api.userSteps.campaignSteps().getCampaign(client, campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6433")
    public void payCampaignsTest() {
        Money sum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT();
        api.userSteps.financeSteps().payCampaigns(new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(api.userSteps.balanceSteps().getDefaultContract(User.get(operator).getClientID()))
                .withPayments(new PayCampElementMap<>(new PayCampElement())
                        .withCampaignID(campaignID)
                        .withCurrency(currency)
                        .withSum(sum.floatValue())));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChangedOnFunds(
                client, campaign, sum.subtractVAT()));
    }
}
