package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.math.RoundingMode;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 25.05.14
 * https://jira.yandex-team.ru/browse/TESTIRT-513
 */
@Aqua.Test
@Feature(FinanceFeatures.PAY_CAMPAIGNS)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
public class PayCampaignsSumFieldTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String rubAgency = Logins.AGENCY_RUB;
    private static String rubClient = Logins.SUBCLIENT_RUB;
    private static String uahAgency = Logins.AGENCY_UAH;
    private static String uahClient = Logins.SUBCLIENT_UAH;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6435")
    public void rubClientPayCampaignsWithSumLessThanMinRUBCurrency() {
        api.as(rubAgency);
        long campaignID = api.userSteps.addActiveCampaign(rubClient, 1);
        float sum = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount()
                .addVAT().setScale(2, RoundingMode.HALF_UP).getPrevious().floatValue();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(rubAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для кампании рублевого клиента со значением Sum меньше минимально " +
                "допустимого для данной валюты");
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(354, AxisErrorDetails.LOW_CURRENCY_PAYMENT_AMOUNT,
                        MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB).getApiDescription(), campaignID),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum)
                                .withCurrency(Currency.RUB)));
    }

    // disabled due to https://st.yandex-team.ru/DIRECT-66515
    //@Test
    // @ru.yandex.qatools.allure.annotations.TestCaseId("6436")
    public void uahClientPayCampaignsWithSumLessThanMinUAHCurrency() {
        api.as(uahAgency);
        long campaignID = api.userSteps.addActiveCampaign(uahClient, 1);
        float sum = MoneyCurrency.get(Currency.UAH).getMinInvoiceAmount()
                .addVAT().setScale(2, RoundingMode.HALF_UP).getPrevious().floatValue();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(uahAgency).getClientID());
        log.info("Вызываем метод PayCampaigns для кампании гривневого клиента со значением Sum меньше минимально " +
                "допустимого для данной валюты");
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(354, AxisErrorDetails.LOW_CURRENCY_PAYMENT_AMOUNT,
                        MoneyCurrency.get(Currency.UAH).getMinInvoiceAmount().stringValue(MoneyFormat.TWO_DIGITS_POINT),
                        MoneyCurrency.get(Currency.UAH).getApiDescription(), campaignID),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum)
                                .withCurrency(Currency.UAH)));
    }
}
