package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Feature(FinanceFeatures.PAY_CAMPAIGNS)
@Stories(ApiStories.CURRENCY)
@RunWith(Parameterized.class)
public class PayCampaignsYFTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String agency;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameters(name = "edit = {0}, transfer = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_RUB, Logins.SUBCLIENT_RUB},
                {Logins.AGENCY_EUR, Logins.SUBCLIENT_EUR},
                {Logins.BYN_AGENCY2, Logins.BYN_SUBCLIENT2}
        };
        return Arrays.asList(data);
    }

    @Test
    public void payCampaignsYndFixedCurrencyClient() {
        api.as(agency);
        long campaignID = api.userSteps.addActiveCampaign(client, 1);
        Money sum = MoneyCurrency.get(null).getMinInvoiceAmount();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(agency).getClientID());

        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(new AxisError(245),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.YND_FIXED)
                                .withSum(sum.floatValue())));
    }

    @Test
    public void payCampaignsNoCurrencyClient() {
        api.as(agency);
        long campaignID = api.userSteps.addActiveCampaign(client, 1);
        Money sum = MoneyCurrency.get(null).getMinInvoiceAmount();
        String contract =
                api.userSteps.balanceSteps().getDefaultContract(User.get(agency).getClientID());

        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(new AxisError(245),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.BANK)
                        .withContractID(contract)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withSum(sum.floatValue())));
    }
}
