package ru.yandex.autotests.directapi.finance.paycampaigns;

import java.math.RoundingMode;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.matchers.finance.AccountMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 17.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.BUG)
//отключено до починки выдачи платежных токенов на koga (TESTIRT-10089)
public class PayCampaignsYMAccountTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = FinanceLogins.FREE_CLIENT_YM;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Money minPaymentAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();
    private static long campaignID1;
    private static long campaignID2;

    @BeforeClass
    public static void getAccountIDs() {
        campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID2 = api.userSteps.addModeratedCampaign();
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(login);
        api.as(login).userSteps.balanceSteps().synchronizeWithBalance(
                ((Account) api.userSteps.financeSteps().getAccount(login)).getAccountID());

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6442")
    public void payCampaign() {
        Account account = api.userSteps.financeSteps().getAccount(login);
        Float amount = account.getAmount();
        api.userSteps.financeSteps().payCampaignsYM(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(minPaymentAmount.addVAT().floatValue())
        );


        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.financeSteps().accountAmountChanged(account), equalTo(true));
        account = api.userSteps.financeSteps().getAccount(login);
        assertThat("Неверная сумма на счёте", account.getAmount(), equalTo(minPaymentAmount.add(amount).floatValue()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6439")
    public void payCampaignWithoutPaymentToken() {
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(360, null),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.YM)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignID1)
                                .withCurrency(Currency.RUB)
                                .withSum(minPaymentAmount.addVAT().floatValue()))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6437")
    public void payCampaigns() {
        Account account = api.userSteps.financeSteps().getAccount(login);
        Float amount = account.getAmount();
        api.userSteps.financeSteps().payCampaignsYM(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(minPaymentAmount.addVAT().floatValue()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID2)
                        .withCurrency(Currency.RUB)
                        .withSum(minPaymentAmount.addVAT().floatValue())
        );


        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.financeSteps().accountAmountChangedOnSum(
                        account, minPaymentAmount.multiply(2f).floatValue()), equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6440")
    public void payCampaignsDifferentCurrency() {
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaignsYM(
                new AxisError(245, AxisErrorDetails.ALL_AMOUNTS_MUST_BE_IN_THE_SAME_CURRENCY),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.YM)
                        .withPayments(new PayCampElementMap(api.type())
                                        .withCampaignID(campaignID1)
                                        .withSum(minPaymentAmount.addVAT().floatValue()),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignID2)
                                        .withCurrency(Currency.RUB)
                                        .withSum(minPaymentAmount.addVAT().floatValue()))
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6441")
    public void payCampaignsNoCurrency() {
        Account account = api.userSteps.financeSteps().getAccount(login);
        Float amount = account.getAmount();
        api.userSteps.financeSteps().payCampaignsYM(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withSum(30f),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID2)
                        .withSum(40f)
        );


        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.financeSteps().accountAmountChanged(account), equalTo(true));
        account = api.userSteps.financeSteps().getAccount(login);
        float expectedAmount = Money.valueOf(70f, Currency.YND_FIXED).convert(Currency.RUB)
                .setScale(2, RoundingMode.HALF_UP).floatValue();

        assertThat(account, AccountMatcher.hasAmount(equalTo(Money.valueOf(amount).add(expectedAmount).floatValue())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6438")
    public void payAccountID() {
        Account account = api.userSteps.financeSteps().getAccount(login);
        api.userSteps.financeSteps().shouldGetErrorOnPayCampaigns(
                new AxisError(1),
                new PayCampaignsInfoMap(api.type())
                        .withPayMethod(PayMethod.YM)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(account.getAccountID())
                                .withCurrency(Currency.RUB)
                                .withSum(minPaymentAmount.addVAT().floatValue()))
        );
    }
}
