package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.balancesimple.response.BindCreditCardResponse;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
public class PayCampaignsByCardApplicationVersionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final Currency CURRENCY = Currency.RUB;

    private static final String LOGIN = Logins.LOGIN_FOR_RUB;

    private String paymentMethod;
    private String customTransactionId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(LOGIN);
        BindCreditCardResponse bindCreditCardResponse = api.userSteps.balanceSimpleSteps().bindCreditCard(
                new BindCreditCardRequest().defaultCreditCard());
        paymentMethod = bindCreditCardResponse.getPaymentMethod();

        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    @Test
    public void payCampaignByCardWithVersion() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
        Money paySum = Money.valueOf(1000);

        api.userSteps.financeSteps().payCampaignsByCard(
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID(paymentMethod)
                .withVersion("20502A")
                .withCustomTransactionID(customTransactionId)
                .withPayments(new PayCampElementMap(api.type())
                        .withCampaignID(campaignId)
                        .withCurrency(CURRENCY)
                        .withSum(paySum.addVAT(CURRENCY))));
    }

    @Test
    public void payCampaignByCardWithNoVersion() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
        Money paySum = Money.valueOf(1000);

        api.userSteps.financeSteps().shouldGetErrorOn(
                Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID(paymentMethod)
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withCurrency(CURRENCY)
                                .withSum(paySum.addVAT(CURRENCY))),
                new AxisError(365, AxisErrorDetails.PLEASE_UPDATE_APPLICATION));
    }
}
