package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 16.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Description("Проверка валидации поля CampaignID в запросе: негативные проверки")
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@RunWith(Parameterized.class)
public class PayCampaignsByCardCampaignIdValidationNegativeTest {

    private static final String LOGIN = Logins.LOGIN_FOR_TRY;
    private static final String ANOTHER_LOGIN = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public long campaignId;

    @Parameterized.Parameter(2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}: CampaignID = {1}")
    public static Iterable<Object[]> data() {
        api.as(LOGIN);
        long deletedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsDelete(deletedCampaignId);
        long nonExistentCampaignId = deletedCampaignId + 100_000;

        api.as(ANOTHER_LOGIN);
        long foreignCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        api.as(LOGIN);
        return Arrays.asList(new Object[][]{
                {"нулевой идентификатор кампании", 0L, new AxisError(1)},
                {"отрицательный идентификатор кампании идентификатор кампании", -1L, new AxisError(1)},
                {"идентификатор удалённой кампании", deletedCampaignId, new AxisError(1)},
                {"идентификатор несуществующей кампании", nonExistentCampaignId, new AxisError(1)},
                {"идентификатор чужой кампании", foreignCampaignId, new AxisError(54)},
        });
    }

    private static String customTransactionId;

    @BeforeClass
    public static void createCampaign() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6460")
    public void invalidCampaignIdInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withCurrency(Currency.RUB)
                                .withSum(42.0f)),
                expectedError);
    }
}
