package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@RunWith(Parameterized.class)
@Description("Проверка запрета оплаты общего счёта с помощью метода AccountManagement.DepositByCard в гривнах")
@Issue("https://st.yandex-team.ru/DIRECT-66515")
public class PayCampaignsByCardCurrencyUAHNegativeTest {

    private static final String clientLogin = Logins.LOGIN_FOR_UAH;
    private static final String customTransactionId =
            randomAlphanumeric(AccountManagementRequestMap.CUSTOM_TRANSACTION_ID_LENGTH);
    private static final float randomPaymentAmount = 1000.0f;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String payMethodId;
    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Currency currency;

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @BeforeClass
    public static void initTest() {
        api.as(clientLogin);
        api.userSteps.addModeratedCampaign(clientLogin);

        api.as(clientLogin).userSteps.balanceSimpleSteps()
                .bindCreditCard(new BindCreditCardRequest().defaultCreditCard());
        payMethodId = api.userSteps.balanceSimpleSteps().getPaymentMethod();

        campaignId = api.userSteps.addModeratedCampaign(clientLogin);
    }

    @Parameterized.Parameters()
    public static Collection payments() {
        Object[][] data = new Object[][]{
                {null},
                {Currency.UAH},
        };
        return Arrays.asList(data);
    }

    @Test
    public void test() {
        String curr = currency != null ? currency.toString() : null;
        log.info("Вызываем метод PayCampaignsByCard для украинского клиента. Currency " + curr);

        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID(payMethodId)
                        .withCustomTransactionID(customTransactionId)
                        .withVersion("20502A")
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withCurrency(currency)
                                .withSum(randomPaymentAmount)),
                new AxisError(245));
    }
}
