package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 16.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Description("Проверка валидации поля CustomTransactionID в запросе: негативные проверки")
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@RunWith(Parameterized.class)
public class PayCampaignsByCardCustomTransactionIdValidationNegativeTest {

    private static final String LOGIN = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String customTransactionId;

    @Parameterized.Parameter(2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}: CustomTransactionID = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"число символов меньше требуемого",
                        randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH - 1),
                        new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAINS_N_ALPHANUMERIC_CHARS,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID),
                                PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},

                {"число символов больше требуемового",
                        randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH + 1),
                        new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAINS_N_ALPHANUMERIC_CHARS,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID),
                                PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},

                {"запрещённые символы в запросе",
                        randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH - 1) + 'щ',
                        new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAINS_N_ALPHANUMERIC_CHARS,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID),
                                PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},

                {"отутствие значения", null,
                        new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID))},

                {"строка из пробела", " ",
                        new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID))},

                {"пустая строка", "",
                        new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID))},

                {"строка правильной длины с пробелами в начале и в конце",
                        " " + randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH) + " ",
                        new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAINS_N_ALPHANUMERIC_CHARS,
                                capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID),
                                PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH)},
        });
    }

    private static long campaignId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6471")
    public void invalidCustomTransactionIdInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("payMethodNotFound")
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withSum(42.0f)),
                expectedError);
    }
}
