package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Вызов метода для кампаний, тип которых является отличным от текстовой")
@RunWith(Parameterized.class)
public class PayCampaignsByCardForNonTextCampaignsTest {

    private static final String LOGIN = Logins.CLIENT_FOR_RUB;
    private static final String ANOTHER_LOGIN = Logins.CLIENT_DOT_LOGIN_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public CampaignsType campaignType;

    @Parameterized.Parameters(name = "type = {0}")
    public static Iterable<Object[]> data() {
        return Stream.of(CampaignsType.values())
                .filter(type -> type != CampaignsType.TEXT && type != CampaignsType.WALLET)
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    private static String customTransactionId;
    private static long nonTextCampaign;
    private static long textCampaignId;

    @BeforeClass
    public static void createCampaign() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);

        nonTextCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(nonTextCampaign);

        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(textCampaignId);
    }

    @Before
    public void setCampaignType() {
        api.userSteps.campaignFakeSteps().setType(nonTextCampaign, campaignType);
        api.as(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6475")
    public void nonTextCampaignInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(nonTextCampaign)
                                .withCurrency(Currency.RUB)
                                .withSum(MoneyCurrency.get(Currency.RUB).getMinTransferAmount().addVAT())),
                new AxisError(368, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6473")
    public void nonTextAndTextCampaignsInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaign)
                                        .withCurrency(Currency.RUB)
                                        .withSum(450.0f),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(textCampaignId)
                                        .withCurrency(Currency.RUB)
                                        .withSum(450.0f)),
                new AxisError(366, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6474")
    public void foreignNonTextCampaignInRequest() {
        api.as(ANOTHER_LOGIN);
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(nonTextCampaign)
                                .withCurrency(Currency.RUB)
                                .withSum(450.0f)),
                new AxisError(54));
    }
}
