package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 06.10.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Вызов метода для валют отличных от рублей или фишек")
@RunWith(Parameterized.class)
public class PayCampaignsByCardForNotAvailableCurrencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public Currency currency;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameters(name = "Currency = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Currency.KZT, Logins.LOGIN_FOR_KZT},
                {Currency.EUR, Logins.LOGIN_FOR_EUR},
                {Currency.USD, Logins.LOGIN_FOR_USD},
                {Currency.CHF, Logins.LOGIN_FOR_CHF},
                {Currency.TRY, Logins.LOGIN_FOR_TRY},
                {Currency.BYN, Logins.BYN_CLIENT2},
        });
    }

    private static String customTransactionId = randomAlphanumeric(
            PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);

    private long campaignId;
    private String payMethodId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(login);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
        payMethodId = api.userSteps.balanceSimpleSteps().bindCreditCard(new BindCreditCardRequest()
                .defaultCreditCard()).getPaymentMethod();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6476")
    public void requestWithCurrency() {
        float sum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT().floatValue() * 2;

        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID(payMethodId)
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withCurrency(currency)
                                .withSum(sum)),
                new AxisError(371, AxisErrorDetails.EMPTY_STRING));
    }
}
