package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;
import java.util.HashMap;

import org.apache.commons.beanutils.BeanMap;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 16.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Неверные по структуре запросы")
public class PayCampaignsByCardInvalidRequestTest {
    private static final String LOGIN = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String payMethodId;
    private static String customTransactionId;
    private static long campaignId;

    private static class JSONObject extends HashMap<String, Object> {
    }

    @BeforeClass
    public static void createCampaign() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
        payMethodId = api.userSteps.balanceSimpleSteps().bindCreditCard(new BindCreditCardRequest()
                .defaultCreditCard()).getPaymentMethod();
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
    }

    @Test
    @Description("Пустой запрос")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6478")
    public void emptyRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                (BeanMap) null,
                new AxisError(501));
    }

    @Test
    @Description("Запрос без структуры Payments")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6477")
    public void requestWithoutPayments() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID(payMethodId)
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments((PayCampElementMap[]) null),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAYMENTS)));
    }

    @Test
    @Description("Запрос без поля CampaignID")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6479")
    public void requestWithoutCampaignId() {
        JSONObject payments = new JSONObject();
        payments.put(capitalize(PayCampElementMap.SUM), 400.0f);

        JSONObject request = new JSONObject();
        request.put(capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID), payMethodId);
        request.put(capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID), customTransactionId);
        request.put(capitalize(PayCampaignsByCardInfoMap.PAYMENTS), Arrays.asList(payments));
        request.put(capitalize(PayCampaignsByCardInfoMap.VERSION), "20502A");

        api.userSteps.shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                request,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(PayCampElementMap.CAMPAIGN_ID)));
    }

    @Test
    @Description("Запрос без поля Sum")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6480")
    public void requestWithoutSum() {
        JSONObject payments = new JSONObject();
        payments.put(capitalize(PayCampElementMap.CAMPAIGN_ID), campaignId);

        JSONObject request = new JSONObject();
        request.put(capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID), payMethodId);
        request.put(capitalize(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID), customTransactionId);
        request.put(capitalize(PayCampaignsByCardInfoMap.PAYMENTS), singletonList(payments));
        request.put(capitalize(PayCampaignsByCardInfoMap.VERSION), "20502A");

        api.userSteps.shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                request,
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(PayCampElementMap.SUM)));
    }
}
