package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 16.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Проверка валидации поля PayMethodID в запросе: негативные проверки")
@RunWith(Parameterized.class)
public class PayCampaignsByCardPayMethodIdValidationNegativeTest {

    private static final String LOGIN = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String payMethodId;

    @Parameterized.Parameter(2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}: PayMethodID = {1}")
    public static Iterable<Object[]> data() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
        return Arrays.asList(new Object[][]{
                {"строка из пробела", " ", new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID))},

                {"пустая строка", "", new AxisError(71, AxisErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID))},

                {"отсутствие значения", null, new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(PayCampaignsByCardInfoMap.PAY_METHOD_ID))},

                {"запрещённые символы в запросе", "card-x7777щ",
                        new AxisError(354, AxisErrorDetails.LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_CUSTOM, MoneyCurrency
                                .get(Currency.RUB).getMinTransferAmount()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MoneyCurrency.get(Currency.RUB).getAbbreviation("en").toLowerCase(),
                                campaignId)},

                {"карточка не принадлежащая пользователю", "card-x99999",
                        new AxisError(354, AxisErrorDetails.LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_CUSTOM,
                                MoneyCurrency.get(Currency.RUB).getMinTransferAmount()
                                        .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                MoneyCurrency.get(Currency.RUB).getAbbreviation("en").toLowerCase(),
                                campaignId)},
        });
    }

    private static String customTransactionId;
    private static long campaignId;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6483")
    public void invalidPayMethodIdInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID(payMethodId)
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withCurrency(Currency.RUB)
                                .withSum(42.0f)),
                expectedError);
    }
}
