package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Description("Проверка прав внутренних ролей: негативные сценарии")
@RunWith(Parameterized.class)
public class PayCampaignsByCardRolesNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operator;

    @Parameterized.Parameter(1)
    public String loginToCreateCampaign;

    @Parameterized.Parameter(2)
    public String campaignOwner;

    @Parameterized.Parameters(name = "operator = {0}, login = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.PLACER, Logins.SUPER_LOGIN, Logins.CLIENT_FOR_RUB},
                {Logins.SUPPORT, Logins.SUPER_LOGIN, Logins.CLIENT_FOR_RUB},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, Logins.CLIENT_FOR_RUB},
                {Logins.MEDIA, Logins.SUPER_LOGIN, Logins.CLIENT_FOR_RUB},
                {Logins.SUPER_READER, Logins.SUPER_LOGIN, Logins.CLIENT_FOR_RUB},
                {Logins.AGENCY_RUB, Logins.AGENCY_RUB, Logins.SUBCLIENT_RUB},
                {Logins.MANAGER_DEFAULT, Logins.SUPER_LOGIN, Logins.LOGIN_FOR_RUB},
        });
    }

    private static long campaignId;
    private static String customTransactionId;

    @BeforeClass
    public static void prepareData() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(loginToCreateCampaign);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(campaignOwner);
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6484")
    public void requestUsingRole() {
        api.as(operator);
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withVersion("20502A")
                        .withCustomTransactionID(customTransactionId)
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignId)
                                .withCurrency(Currency.RUB)
                                .withSum(450.0f)),
                new AxisError(54));
    }
}
