package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Запрос с несколькими одинаковыми идентификаторами кампании в запросе")
public class PayCampaignsByCardSameCampaignIdsTest {

    private static final String LOGIN = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String customTransactionId;
    private static long campaignId;

    @BeforeClass
    public static void createCampaign() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignId);
    }

    @Test
    @Description("Два одинаковых идентификатора кампании в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6485")
    public void twoSameCampaignIdsInRequest() {
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withCustomTransactionID(customTransactionId)
                        .withVersion("20502A")
                        .withPayments(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignId)
                                        .withCurrency(Currency.RUB)
                                        .withSum(50.0f),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignId)
                                        .withCurrency(Currency.RUB)
                                        .withSum(90.0f)),
                new AxisError(354, AxisErrorDetails.FIELD_IN_STRUCTURE_SHOULD_BE_UNIQUE,
                        capitalize(PayCampElementMap.CAMPAIGN_ID),
                        capitalize(PayCampaignsByCardInfoMap.PAYMENTS)));
    }
}
