package ru.yandex.autotests.directapi.finance.paycampaignsbycard;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * Created by semkagtn on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.PAY_CAMPAIGNS_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Запросы с указанием разных валют для кампаний с разными валютами")
public class PayCampaignsByCardWrongCurrencyInRequestTest {

    private static final String LOGIN_RUB = Logins.LOGIN_FOR_RUB;
    private static final String LOGIN_USD = Logins.LOGIN_FOR_USD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String customTransactionId;

    private static long campaignRubId1;
    private static long campaignRubId2;
    private static long campaignUsdId;

    @BeforeClass
    public static void createCampaigns() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);

        api.as(LOGIN_RUB);
        campaignRubId1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignRubId1);
        campaignRubId2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignRubId2);

        api.as(LOGIN_USD);
        campaignUsdId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignFullyModerated(campaignUsdId);
    }

    @Test
    @Description("Вызов метода для двух кампаний, с указанием разных валют для них")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6492")
    public void payTwoCampaignsDifferentCurrency() {
        api.as(LOGIN_RUB);
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withCustomTransactionID(customTransactionId)
                        .withVersion("20502A")
                        .withPayments(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignRubId1)
                                        .withSum(450.0f)
                                        .withCurrency(Currency.RUB),
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignRubId2)
                                        .withCurrency(Currency.USD)
                                        .withSum(450.0f)),
                new AxisError(245, AxisErrorDetails.ALL_AMOUNTS_MUST_BE_IN_THE_SAME_CURRENCY));
    }

    @Test
    @Description("Вызов метода для рублёвой кампании с указанием валюты USD в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6494")
    public void usdCurrencyInRequestForRubCampaign() {
        api.as(LOGIN_RUB);
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withCustomTransactionID(customTransactionId)
                        .withVersion("20502A")
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignRubId1)
                                .withSum(450.0f)
                                .withCurrency(Currency.USD)),
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.RUB));
    }

    @Test
    @Description("Вызов метода для долларовой кампании с указанием валюты RUB в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6495")
    public void rubCurrencyInRequestForUsdCampaign() {
        api.as(LOGIN_USD);
        api.userSteps.financeSteps().shouldGetErrorOn(Method.PAY_CAMPAIGNS_BY_CARD,
                new PayCampaignsByCardInfoMap(api.type())
                        .withPayMethodID("invalidPaymentMethod")
                        .withCustomTransactionID(customTransactionId)
                        .withVersion("20502A")
                        .withPayments(new PayCampElementMap(api.type())
                                .withCampaignID(campaignUsdId)
                                .withSum(450.0f)
                                .withCurrency(Currency.RUB)),
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.USD));
    }
}
