package ru.yandex.autotests.directapi.finance.production;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.Matchers.equalTo;

/**
 * Created by chicos on 28.04.14.
 * <p/>
 * Smoke-тесты на проверку некоторых методов на production окружении
 * https://jira.yandex-team.ru/browse/TESTIRT-1800
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Stories(FinanceFeatures.CREATE_INVOICE)
public class CreateInvoiceProdTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());


    private static String clientLogin = Logins.CLIENT_SMOKE_PROD;
    private static String managerLogin = Logins.MANAGER_DEFAULT;

    private static String selfClientLogin = Logins.DIRECT_LIMIT_MAN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    private static long campaignId1;
    private final int moderatedCampaignId = 9133541;
    private static Money minInvoiceAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();

    @BeforeClass
    public static void prepareCampaigns() {
        campaignId1 = api.as(managerLogin).userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
    }

    @Test
    //No manager role created in Balance production
    @ru.yandex.qatools.allure.annotations.TestCaseId("6496")
    public void couldCreateInvoiceByManager() {
        api.as(managerLogin);
        String requestID = api.userSteps.financeSteps().getRequestID(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignId1)
                        .withCurrency(Currency.RUB.value())
                        .withSum(minInvoiceAmount.addVAT().floatValue()));
        api.userSteps.balanceSteps().operator(User.get(clientLogin)).requestAmountShouldBe(
                requestID, equalTo(minInvoiceAmount.convert(Currency.RUB).addVAT().floatValue()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6497")
    public void couldCreateInvoiceBySelfClient() {
        api.as(selfClientLogin);
        String requestID = api.userSteps.financeSteps().getRequestID(
                new PayCampElementMap(api.type())
                        .withCampaignID(moderatedCampaignId)
                        .withCurrency(Currency.RUB.value())
                        .withSum(minInvoiceAmount.addVAT().floatValue()));
        api.userSteps.balanceSteps().operator(User.get(selfClientLogin)).requestAmountShouldBe(
                requestID, equalTo(minInvoiceAmount.convert(Currency.RUB).addVAT().floatValue()));
    }

    @AfterClass
    public static void removeCampaignsManually() {
        api.as(managerLogin).userSteps.campaignSteps().campaignsDelete(clientLogin, campaignId1);
    }
}
