package ru.yandex.autotests.directapi.finance.smoke;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author andy-ilyin
 * Date 11.04.17
 * <p>
 * Этот тест бесполезен, если BalancePersonsSmokeTest на тех же юзернеймах падает, поэтому сначала надо тот тест
 * чинить, а потом этот.
 * <p>
 * Если этот тест массово падает, надо запустить https://aqua.yandex-team.ru/#/pack/56b9b74ee4b08948c4808585
 * (Balance(old) Restore integration data Direct); если это не поможет, разбираться: создавать контракты вручную
 * и просить Баланс посмотреть, почему их пак не доработал
 * <p>
 * Если этот тест на одном пользователе падает, надо убедиться, что финансовым тестам правда нужен договор
 * у этого пользователя, создать договор и попросить Баланс создавать его скриптом после переналивки
 * (создать sub-task в TESTBALANCE-1446, им понадобятся ClientID в production-базе)
 */
@Aqua.Test
@Issue("DIRECT-65261")
@Features(FinanceFeatures.FINANCE_MONITOR)
@RunWith(Parameterized.class)
public class BalanceContractsSmokeTest {
    @Parameterized.Parameter
    public String testCaseName;

    @Parameterized.Parameter(1)
    public String username;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameters(name = "{0} = {1}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][]{
                new Object[]{"FinanceLogins.AGENCY_DEPOSIT_1", FinanceLogins.AGENCY_DEPOSIT_1},
                new Object[]{"FinanceLogins.AGENCY_DEPOSIT_2", FinanceLogins.AGENCY_DEPOSIT_2},
                new Object[]{"FinanceLogins.AGENCY_ENABLE_SHARED_ACCOUNT", FinanceLogins.AGENCY_ENABLE_SHARED_ACCOUNT},
                new Object[]{"Logins.AGENCY_ANOTHER", Logins.AGENCY_ANOTHER},
                new Object[]{"Logins.AGENCY_EUR", Logins.AGENCY_EUR},
                new Object[]{"Logins.AGENCY_EUR_REP", Logins.AGENCY_EUR_REP},
                new Object[]{"Logins.AGENCY_IN_2_SHARD", Logins.AGENCY_IN_2_SHARD},
                new Object[]{"Logins.AGENCY_RUB", Logins.AGENCY_RUB},
                new Object[]{"Logins.AGENCY_SHARD_2", Logins.AGENCY_SHARD_2},
                new Object[]{"Logins.AGENCY_YE_DEFAULT", Logins.AGENCY_YE_DEFAULT},
                new Object[]{"Logins.BYN_AGENCY2", Logins.BYN_AGENCY2},
                new Object[]{"Logins.AGENCY_DEALS", Logins.AGENCY_DEALS},
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        String defaultContract = api.userSteps.balanceSteps().getDefaultContract(User.get(username).getClientID());
        assertThat("есть договор в Балансе", defaultContract, not(isEmptyOrNullString()));
    }
}
