package ru.yandex.autotests.directapi.finance.smoke;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.PaymentData;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author andy-ilyin
 * Date 11.04.17
 * <p>
 * Если этот тест массово падает, надо запустить https://aqua.yandex-team.ru/#/pack/56b9b74ee4b08948c4808585
 * (Balance(old) Restore integration data Direct); если это не поможет, разбираться: создавать плательщиков вручную
 * и просить Баланс посмотреть, почему их пак не доработал
 * <p>
 * Если этот тест на одном пользователе падает, надо убедиться, что финансовым тестам правда нужен плательщик
 * у этого пользователя,создать плательщика и попросить Баланс создавать его скриптом после переналивки
 * (создать sub-task в TESTBALANCE-1446, им понадобятся ClientID в production-базе)
 * <p>
 * Может статься, в дополнение к плательщику нужен договор (см. BalanceContractsSmokeTest). При обращении к Балансу
 * лучше просить их создавать плательщика и договор сразу, чтобы не просить два раза.
 */
@Aqua.Test
@Issue("DIRECT-65261")
@Features(FinanceFeatures.FINANCE_MONITOR)
@RunWith(Parameterized.class)
public class BalancePersonsSmokeTest {
    @Parameterized.Parameter
    public String testCaseName;

    @Parameterized.Parameter(1)
    public String username;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameters(name = "{0} = {1}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][]{
                new Object[]{"FinanceLogins.AGENCY_DEPOSIT_1", FinanceLogins.AGENCY_DEPOSIT_1},
                new Object[]{"FinanceLogins.AGENCY_DEPOSIT_2", FinanceLogins.AGENCY_DEPOSIT_2},
                new Object[]{"FinanceLogins.AGENCY_ENABLE_SHARED_ACCOUNT", FinanceLogins.AGENCY_ENABLE_SHARED_ACCOUNT},
                new Object[]{"FinanceLogins.AGENCY_FREE_CLIENT_ACCOUNT", FinanceLogins.AGENCY_FREE_CLIENT_ACCOUNT},
                new Object[]{"FinanceLogins.AGENCY_INVOICE_1", FinanceLogins.AGENCY_INVOICE_1},
                new Object[]{"FinanceLogins.AGENCY_INVOICE_2", FinanceLogins.AGENCY_INVOICE_2},
                new Object[]{"FinanceLogins.AGENCY_TMONEY", FinanceLogins.AGENCY_TMONEY},
                new Object[]{"FinanceLogins.AGENCY_TMONEY_AGENT2", FinanceLogins.AGENCY_TMONEY_AGENT2},
                new Object[]{"FinanceLogins.CLIENT_NO_ACCOUNT", FinanceLogins.CLIENT_NO_ACCOUNT},
                new Object[]{"FinanceLogins.DEPOSIT_BY_CARD_CLIENT2", FinanceLogins.DEPOSIT_BY_CARD_CLIENT2},
                new Object[]{"FinanceLogins.DEPOSIT_FREE_CLIENT", FinanceLogins.DEPOSIT_FREE_CLIENT},
                new Object[]{"FinanceLogins.DISCOUNT_CLIENT", FinanceLogins.DISCOUNT_CLIENT},
                new Object[]{"FinanceLogins.FREE_CLIENT_OVERDRAFT2", FinanceLogins.FREE_CLIENT_OVERDRAFT2},
                new Object[]{"FinanceLogins.INVOICE_FREE_CLIENT", FinanceLogins.INVOICE_FREE_CLIENT},
                new Object[]{"FinanceLogins.MANAGER_LOGIN", FinanceLogins.MANAGER_LOGIN},
                new Object[]{"FinanceLogins.OLD_OVERDRAFT_CLIENT", FinanceLogins.OLD_OVERDRAFT_CLIENT},
                new Object[]{"FinanceLogins.OVERDRAFT_CLIENT3", FinanceLogins.OVERDRAFT_CLIENT3},
                new Object[]{"FinanceLogins.TRANSFER_LOGIN", FinanceLogins.TRANSFER_LOGIN},
                new Object[]{"Logins.AGENCY_ANOTHER", Logins.AGENCY_ANOTHER},
                new Object[]{"Logins.AGENCY_EUR", Logins.AGENCY_EUR},
                new Object[]{"Logins.AGENCY_EUR_REP", Logins.AGENCY_EUR_REP},
                new Object[]{"Logins.AGENCY_IN_2_SHARD", Logins.AGENCY_IN_2_SHARD},
                new Object[]{"Logins.AGENCY_RUB", Logins.AGENCY_RUB},
                new Object[]{"Logins.AGENCY_SHARD_2", Logins.AGENCY_SHARD_2},
                new Object[]{"Logins.AGENCY_YE_DEFAULT", Logins.AGENCY_YE_DEFAULT},
                new Object[]{"Logins.API_SUBCLIENT", Logins.API_SUBCLIENT},
                new Object[]{"Logins.BYN_AGENCY2", Logins.BYN_AGENCY2},
                new Object[]{"Logins.BYN_CLIENT2", Logins.BYN_CLIENT2},
                new Object[]{"Logins.CLIENT_DOT_LOGIN", Logins.CLIENT_DOT_LOGIN},
                new Object[]{"Logins.CLIENT_FREE_YE_DEFAULT", Logins.CLIENT_FREE_YE_DEFAULT},
                new Object[]{"Logins.CLIENT_SELF", Logins.CLIENT_SELF},
                new Object[]{"Logins.LOGIN_FOR_CHF", Logins.LOGIN_FOR_CHF},
                new Object[]{"Logins.LOGIN_FOR_EUR", Logins.LOGIN_FOR_EUR},
                new Object[]{"Logins.LOGIN_FOR_KZT", Logins.LOGIN_FOR_KZT},
                new Object[]{"Logins.LOGIN_FOR_RUB", Logins.LOGIN_FOR_RUB},
//                new Object[]{"Logins.LOGIN_FOR_TRY", Logins.LOGIN_FOR_TRY},// DIRECT-130518: Выпилить платежи в Турцию из aqua-тестов
                new Object[]{"Logins.LOGIN_FOR_USD", Logins.LOGIN_FOR_USD},
                new Object[]{"Logins.MANAGER_DEFAULT", Logins.MANAGER_DEFAULT},
                new Object[]{"Logins.AGENCY_DEALS", Logins.AGENCY_DEALS},
                new Object[]{"WebTestLogins.AT_CAMPAIGN_MNGR_SERVICED", WebTestLogins.AT_CAMPAIGN_MNGR_SERVICED},
                new Object[]{"WebTestLogins.AT_DIRECT_FINANCE_LOGIN_WITHOUT_WALLET", WebTestLogins.AT_DIRECT_FINANCE_LOGIN_WITHOUT_WALLET},
                new Object[]{"WebTestLogins.AT_DIRECT_FINANCE_PAYMENT_LOGIN", WebTestLogins.AT_DIRECT_FINANCE_PAYMENT_LOGIN},
                new Object[]{"WebTestLogins.AT_DIRECT_FINANCE_PAYMENT_LOGIN_WITHOUT_WALLET", WebTestLogins.AT_DIRECT_FINANCE_PAYMENT_LOGIN_WITHOUT_WALLET},
                new Object[]{"WebTestLogins.AT_DIRECT_FINANCE_PAYMENT_SERVECED_CLIENT", WebTestLogins.AT_DIRECT_FINANCE_PAYMENT_SERVECED_CLIENT},
                new Object[]{"WebTestLogins.AT_DIRECT_TRANSFER_KZT", WebTestLogins.AT_DIRECT_TRANSFER_KZT},
                new Object[]{"WebTestLogins.AT_DIRECT_TRANSFER_RUB", WebTestLogins.AT_DIRECT_TRANSFER_RUB},
//                new Object[]{"WebTestLogins.AT_DIRECT_TRANSFER_TRY", WebTestLogins.AT_DIRECT_TRANSFER_TRY}, // DIRECT-130518: Выпилить платежи в Турцию из aqua-тестов
                new Object[]{"WebTestLogins.AT_TRANSFER_WITHOUT_WALLET", WebTestLogins.AT_TRANSFER_WITHOUT_WALLET},
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        PaymentData paymentData = api.userSteps.balanceSteps().getPaymentData(username);
        assertThat("есть плательщик в Балансе", paymentData.getPersonID(), allOf(not(nullValue()), not(equalTo(0))));
    }

    // частично зеркалит ru.yandex.autotests.direct.web.data.TestLogins
    private static class WebTestLogins {
        private WebTestLogins() {
        }

        static final String AT_CAMPAIGN_MNGR_SERVICED = "at-campaign-mngr-serviced";
        static final String AT_DIRECT_FINANCE_LOGIN_WITHOUT_WALLET = "at-direct-adv-std";
        static final String AT_DIRECT_FINANCE_PAYMENT_LOGIN = "at-direct-back-finance";
        static final String AT_DIRECT_FINANCE_PAYMENT_LOGIN_WITHOUT_WALLET = "at-direct-without-wallet";
        static final String AT_DIRECT_FINANCE_PAYMENT_SERVECED_CLIENT = "at-direct-src-camp-c3";
        static final String AT_DIRECT_TRANSFER_KZT = "at-direct-transfer-kzt";
        static final String AT_DIRECT_TRANSFER_RUB = "at-direct-transfer-rub";
        static final String AT_DIRECT_TRANSFER_TRY = "at-direct-transfer-try";
        static final String AT_TRANSFER_WITHOUT_WALLET = "at-transfer-without-wallet";
    }
}
