package ru.yandex.autotests.directapi.finance.smoke;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.matchers.axiserror.ApiResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.CoreMatchers.not;
import static org.junit.Assert.assertThat;

/**
 * Author pavryabov
 * Date 12.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.FINANCE_MONITOR)
@Stories(FinanceFeatures.CLIENT_ACCOUNT)
@RunWith(Parameterized.class)
public class CheckAccountAtApiClientSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.CLIENT_FREE_YE_DEFAULT},
                {Logins.SPB_TESTER}
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6498")
    public void checkAccountTest() {
        Object response = api.as(login).userSteps.soapClient().invokeMethod(
                Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap(api.type())
                        .withAction(Action.GET)
                        .withSelectionCriteria(
                                new AccountSelectionCriteriaMap(api.type())
                                        .withLogins(login)
                        ).getBean()
        );
        assertThat("У клиента " + login + " включен общий счет",
                JsonUtils.toString(response), not(ApiResponse.hasNoError()));
        assertThat("Неправильная ошибка при проверке общего счета " + login,
                JsonUtils.toString(response), ApiResponse.hasErrors(new AxisError(515, AxisErrorDetails.EMPTY_STRING)));
    }
}
