package ru.yandex.autotests.directapi.finance.smoke;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.lessThan;

/**
 * Author pavryabov
 * Date 21.04.14
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Stories(FinanceFeatures.CONTRACTS_REST)
@RunWith(Parameterized.class)
public class ContractsRestSmokeTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public int contractNumber;

    @Parameterized.Parameters(name = "Login = {0}, contract = {1}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.AGENCY_YE_DEFAULT, 1},
                {Logins.AGENCY_YE_DEFAULT, 2},
                {Logins.AGENCY_YE_DEFAULT, 3},
                {Logins.AGENCY_SHARD_2, 1},
                {FinanceLogins.AGENCY_DEPOSIT_1, 1},
                {Logins.AGENCY_RUB, 1},
                {Logins.AGENCY_UAH, 1},
                {Logins.AGENCY_ANOTHER, 1}
        });
    }

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6499")
    public void getContractRest() {
        //Данный тест больше не используется в светофоре, потому что большой лимит по договорам позволяет их не пополнять
        //Тест оставлен в паке, чтобы не потерять пример выставления и погашения счетов
        api.as(Logins.SUPER_LOGIN, login);
        String contractID =
                api.userSteps.balanceSteps().getDefaultContract(User.get(login).getClientID(), contractNumber);
        log.info("ID контракта " + contractID);
        if (api.userSteps.financeSteps().getContractSpent(contractID).floatValue() > 70000f) {
            String internalConractID =
                    api.userSteps.balanceSteps().getInternalContractID(User.get(login).getClientID(), contractID);
            api.userSteps.balanceSteps().repaymentInvoicesByContract(internalConractID);
            api.userSteps.balanceSteps().payAllInvoicesByContract(internalConractID);
            assertThat("Не удалось погасить счета по контракту",
                    api.userSteps.financeSteps().getContractSpent(contractID).floatValue(),
                    lessThan(70000f));
        }
    }
}
