package ru.yandex.autotests.directapi.finance.smoke;

import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

/**
 * Author pavryabov
 * Date 08.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.FINANCE_MONITOR)
@Stories(FinanceFeatures.CREATE_ACTIVE_CAMPAIGN)
public class CreateAgencyActiveCampaignSmokeTest {
    private static final String LOGIN = Logins.SUBCLIENT_RUB;
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6500")
    public void createAndPayAgencyCampaign() {
        Double clientVatRate = api.userSteps.clientsStepsV5().getClientVatRate(LOGIN);
        long campaignID =
                api.as(Logins.AGENCY_RUB).userSteps.addActiveCampaign(LOGIN, MoneyCurrency.get(Currency.RUB)
                        .withVatRate(clientVatRate).getMinInvoiceAmount().addVAT().floatValue(), Currency.RUB);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                .setBalanceTid(campaignID, DateTime.now().getMillis() * 10); //fix for trashman
    }
}
