package ru.yandex.autotests.directapi.finance.smoke;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThan;

/**
 * Author pavryabov
 * Date 08.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.FINANCE_MONITOR)
@Stories(FinanceFeatures.GET_DATA_FROM_BALANCE)
public class GetContractSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6503")
    public void getAgencyContract() {
        assertThat("Нет договоров у агентства",
                Integer.parseInt(User.get(Logins.AGENCY_YE_DEFAULT).getContractID()), greaterThan(0));
    }
}
