package ru.yandex.autotests.directapi.finance.smoke;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

/**
 * Author pavryabov
 * Date 08.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.NOTIFICATIONS_MONITOR)
@Stories(FinanceFeatures.NOTIFY_ORDER2)
public class NotificationFromBalanceSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(Logins.AGENCY_RUB);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6505")
    public void notificationFromBalanceTest() {
        Double clientVatRate = api.userSteps.clientsStepsV5().getClientVatRate(Logins.AGENCY_RUB);
        float sumForCreate =
                MoneyCurrency.get(Currency.RUB).withVatRate(clientVatRate).getMinInvoiceAmount().addVAT().floatValue();
        long campaignID = api.userSteps.addActiveCampaign(Logins.SUBCLIENT_RUB, sumForCreate, Currency.RUB);
        try {
            ConditionFactories.NOTIFY_PAYMENT.until(api.userSteps.campaignSteps()
                    .campaignFundsChanged(Logins.SUBCLIENT_RUB, campaignID, true));
        } catch (Exception e) {
            throw new AssertionError("Не пришла нотификация из Баланса. Кампания " + campaignID);
        }
    }
}
