package ru.yandex.autotests.directapi.finance.smoke;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.terra.junit.rules.BottleMessageRule;

/**
 * Author pavryabov
 * Date 21.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.FINANCE_MONITOR)
@Stories(FinanceFeatures.OVERDRAFT_REST)
@RunWith(Parameterized.class)
public class OverdraftSmokeTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {FinanceLogins.FREE_CLIENT_OVERDRAFT},
                {FinanceLogins.DEPOSIT_FREE_CLIENT},
                {FinanceLogins.FREE_CLIENT_OVERDRAFT2},
                {FinanceLogins.OVERDRAFT_CLIENT3}
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6506")
    public void getContractRest() {
        //Овердрафт в Директе - это просто лимит и он не меняется.
        // Проверяем его на случай свежей базы, когда он еще не приехал из Баланса
        //Остаток овердрафта получаем от Баланса
        long orderID;
        try {
            orderID = api.as(login).userSteps.financeSteps().getAccountID(login);
        } catch (DirectAPIException e) {
            orderID = api.userSteps.addActiveCampaign(login,
                    MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue(), Currency.RUB);
        }
        Float overdraft = ((ClientInfo) api.userSteps.clientSteps().getClientInfo(login)).getOverdraftSumAvailableInCurrency();
        Float overdraftInBalance = api.userSteps.balanceSteps().getClientOverdraft(login);
        log.info("Клиенту " + login + " доступен овердрафт " + overdraftInBalance);
        boolean overdueInvoices = api.userSteps.balanceSteps().checkOverdueInvoices(login);
        if ((overdraft < 10000f) || (overdraftInBalance < 100000f) || overdueInvoices) {
            api.userSteps.balanceSteps().setClientOverdraft(login);
        }
    }
}
