package ru.yandex.autotests.directapi.finance.smoke;

import java.util.Arrays;
import java.util.List;

import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.AssumptionException;

/**
 * Тест проверяет наличие общих счетов после переналивки баланса и создаёт их при необходимости
 * Прогоняется руками, так что без анноташек
 */
public class WalletsSmokeTest {
    private static final List<String> LOGINS = Arrays.asList(
            "at-sc-tm3",
            "at-sc-tm0",
            "at-sa-overdraft",
            "account-subclient-shard1-2",
            "account-subclient-shard1-3",
            "at-sc-deposit4",
            "at-sc-deposit5",
            "at-sc-deposit6",
            "at-sc-deposit7",
            "at-sc-tm8",
            "at-sc-tm9",
            "account-subclient-shard-2",
            "account-subclient-shard-3");

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @Test
    @Ignore
    public void resetCommonWallet() {
        LOGINS.forEach(login -> resetCommonWalletInternal(login));
    }

    private void resetCommonWalletInternal(String login) {
        Long clientId = api.userSteps.getDirectJooqDbSteps().shardingSteps().getClientIdByLogin(login);
        CampaignsRecord walletRecord = api.userSteps.getDirectJooqDbSteps()
                .useShardForClientId(clientId)
                .campaignsSteps()
                .getWallet(clientId);
        if (walletRecord == null) {
            return;
        }
        Long walletCid = walletRecord.getCid();
        try {
            api.userSteps.balanceSteps().getOrderInfo(walletCid.intValue());
        } catch (AssumptionException e) {
            api.userSteps.getDirectJooqDbSteps().useShardForLogin(login)
                    .campaignsSteps()
                    .setType(Long.valueOf(walletCid), CampaignsType.text);
        }
    }
}
