package ru.yandex.autotests.directapi.finance.transfermoney;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 23.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
@Tag(TagDictionary.TRUNK)
public class DisallowMoneyTransferTest {
    private static String clientLogin = Logins.SUBCLIENT_RUB;
    private static String clientWithDisallowTransfer = FinanceLogins.SUBCLIENT_DISALLOW_TRANSFER_RUB_7;
    private static String agencyLogin = Logins.AGENCY_RUB;
    private static Money sum = MoneyCurrency.get(Currency.RUB).getMinTransferAmount();

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(agencyLogin);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableDisallowMoneyTransfer(clientWithDisallowTransfer);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6507")
    public void expectErrorTransferMoneyFromDisallowMoneyTransferClient() {
        long campaignIDFrom = api.userSteps.addActiveCampaign(clientWithDisallowTransfer, 2500f, Currency.RUB);
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(campaignIDFrom, campaignIDTo, sum.floatValue(), Currency.RUB,
                new AxisError(353, AxisErrorDetails.DISALLOW_TRANSFER_MONEY));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6508")
    public void transferMoneyToDisallowMoneyTransferClient() {
        long campaignIDFrom = api.clientLogin(clientLogin).userSteps.addActiveCampaign(2500f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps()
                        .campaignsGet(campaignIDFrom, CampaignFieldEnum.FUNDS, CampaignFieldEnum.ID);
        long campaignIDTo =
                api.clientLogin(clientWithDisallowTransfer).userSteps.campaignSteps().addDefaultTextCampaign();
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps()
                        .campaignsGet(campaignIDTo, CampaignFieldEnum.FUNDS, CampaignFieldEnum.ID);

        api.userSteps.financeSteps().transferMoney(campaignIDFrom, campaignIDTo, sum.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(clientLogin, campaignFrom, sum.negate()));
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(clientWithDisallowTransfer, campaignTo, sum));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6509")
    public void agencyTransferMoneyBetweenDisallowMoneyTransferClientCampaigns() {
        long campaignIDFrom =
                api.clientLogin(clientWithDisallowTransfer).userSteps.addActiveCampaign(2500f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(clientWithDisallowTransfer);
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps()
                        .campaignsGet(campaignIDFrom, CampaignFieldEnum.FUNDS, CampaignFieldEnum.ID);
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps()
                        .campaignsGet(campaignIDTo, CampaignFieldEnum.FUNDS, CampaignFieldEnum.ID);
        api.userSteps.financeSteps().transferMoney(campaignIDFrom, campaignIDTo, sum.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom, sum.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo, sum));
    }
}

