package ru.yandex.autotests.directapi.finance.transfermoney;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 17.12.13
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1363
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
@RunWith(Parameterized.class)
public class TransferAllWithoutOneCentTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Money sumForCreate;
    private long campaignIDFrom;
    private long campaignIDTo;
    private String currency = null;

    @Parameterized.Parameter(value = 0)
    public String login;

    @Parameterized.Parameter(value = 1)
    public String currencyInError;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_FOR_RUB, MoneyCurrency.get(Currency.RUB).getApiDescription()},
                {Logins.LOGIN_FOR_USD, MoneyCurrency.get(Currency.USD).getApiDescription()},
                {Logins.LOGIN_FOR_EUR, MoneyCurrency.get(Currency.EUR).getAbbreviation("en")},
// DIRECT-66511                {Logins.LOGIN_FOR_UAH, MoneyCurrency.get(Currency.UAH).getApiDescription()},
// DIRECT-130518 {Logins.LOGIN_FOR_TRY, MoneyCurrency.get(Currency.TRY).getAbbreviation("en")},
                {Logins.LOGIN_FOR_KZT, MoneyCurrency.get(Currency.KZT).getAbbreviation("en")}, // DIRECT-65042
                {Logins.LOGIN_FOR_CHF, MoneyCurrency.get(Currency.CHF).getAbbreviation("en")},
                {Logins.BYN_CLIENT2, MoneyCurrency.get(Currency.BYN).getApiDescription()},
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.as(login);
        String[] currencyString = ((ClientInfo) api.userSteps.clientSteps().getClientInfo(login)).getClientCurrencies();
        if (currencyString != null) {
            currency = currencyString[0];
        }
        sumForCreate = MoneyCurrency.get(Currency.getFor(currency)).getMinTransferAmount().multiply(2f).subtract(0.01f);
        campaignIDFrom =
                api.userSteps.addActiveCampaign(sumForCreate.addVAT().floatValue(), Currency.getFor(currency));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        api.userSteps.campaignFakeSteps().makeCampaignStopped(campaignIDFrom);
        campaignIDTo = api.userSteps.addModeratedCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6513")
    public void transferMoney() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDFrom)
                                .withSum(sumForCreate.subtract(0.01f).floatValue())
                                .withCurrency(currency))
                        .withToCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDTo)
                                .withSum(sumForCreate.subtract(0.01f).floatValue())
                                .withCurrency(currency)),
                new AxisError(353, AxisErrorDetails.TRANSFERMONEY_INVALID_REMAINING_BALANCE_WITH_CURRENCY,
                        MoneyCurrency.get(Currency.getFor(currency)).getMinTransferRest()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        currencyInError));
    }
}
