package ru.yandex.autotests.directapi.finance.transfermoney;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.ClientRight;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.clients.RightName;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.having;
import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.selectFirst;

/**
 * Author pavryabov
 * Date 24.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
@Tag(TagDictionary.TRUNK)
public class TransferMoneyAgencySubclientTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = Logins.SUBCLIENT_RUB;
    private static String agencyLogin = Logins.AGENCY_RUB;
    private static Money sum = MoneyCurrency.get(Currency.RUB).getMinTransferAmount();

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long activeCampaignID1;
    private static long activeCampaignID2;

    @BeforeClass
    public static void createCampaigns() {
        api.as(agencyLogin);
        activeCampaignID1 = api.userSteps.addActiveCampaign(clientLogin, 5500f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChanged(clientLogin, activeCampaignID1));
        activeCampaignID2 = api.userSteps.addActiveCampaign(clientLogin, 5500f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChanged(clientLogin, activeCampaignID2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6514")
    public void haveRightToTransferHaveNotToEdit() {
        api.as(agencyLogin);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_EDIT_CAMPAIGNS))))
                .setValue(Value.NO);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_TRANSFER_MONEY))))
                .setValue(Value.YES);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_IMPORT_XLS))))
                .setValue(Value.NO);
        api.userSteps.clientSteps().updateClientInfo(new ClientInfoMap<>(clientInfo));
        api.as(Logins.SUPER_LOGIN, clientLogin);
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps().getCampaign(clientLogin, activeCampaignID1);
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps().getCampaign(clientLogin, activeCampaignID2);
        api.userSteps.financeSteps()
                .transferMoney(activeCampaignID1, activeCampaignID2, sum.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom, sum.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo, sum));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6515")
    public void haveRightToTransferHaveToEdit() {
        api.as(agencyLogin);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_EDIT_CAMPAIGNS))))
                .setValue(Value.YES);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_TRANSFER_MONEY))))
                .setValue(Value.YES);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_IMPORT_XLS))))
                .setValue(Value.NO);
        api.userSteps.clientSteps().updateClientInfo(new ClientInfoMap<>(clientInfo));
        api.as(Logins.SUPER_LOGIN, clientLogin);
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps().getCampaign(clientLogin, activeCampaignID1);
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps().getCampaign(clientLogin, activeCampaignID2);
        api.userSteps.financeSteps()
                .transferMoney(activeCampaignID1, activeCampaignID2, sum.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom, sum.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo, sum));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6516")
    public void haveNotRightToTransferHaveNotToEdit() {
        api.as(agencyLogin);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_EDIT_CAMPAIGNS))))
                .setValue(Value.NO);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_TRANSFER_MONEY))))
                .setValue(Value.NO);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_IMPORT_XLS))))
                .setValue(Value.NO);
        api.userSteps.clientSteps().updateClientInfo(new ClientInfoMap<>(clientInfo));
        api.as(Logins.SUPER_LOGIN, clientLogin);
        api.userSteps.financeSteps()
                .shouldGetErrorOnTransferMoney(activeCampaignID1, activeCampaignID2, sum.floatValue(), Currency.RUB,
                        new AxisError(54, AxisErrorDetails.NO_RIGHTS_FOR_TRANSFER_BETWEEN_AGENCY_CAMPAIGNS));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6517")
    public void haveNotRightToTransferHaveToEdit() {
        api.as(agencyLogin);
        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_EDIT_CAMPAIGNS))))
                .setValue(Value.YES);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_TRANSFER_MONEY))))
                .setValue(Value.NO);
        ((ClientRight) selectFirst(
                Arrays.asList(clientInfo.getClientRights()),
                having(on(ClientRight.class).getRightName(), Matchers.equalTo(RightName.ALLOW_IMPORT_XLS))))
                .setValue(Value.NO);
        api.userSteps.clientSteps().updateClientInfo(new ClientInfoMap<>(clientInfo));
        api.as(Logins.SUPER_LOGIN, clientLogin);
        api.userSteps.financeSteps()
                .shouldGetErrorOnTransferMoney(activeCampaignID1, activeCampaignID2, sum.floatValue(), Currency.RUB,
                        new AxisError(54, AxisErrorDetails.NO_RIGHTS_FOR_TRANSFER_BETWEEN_AGENCY_CAMPAIGNS));
    }
}
