package ru.yandex.autotests.directapi.finance.transfermoney;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 26.08.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
@Tag(TagDictionary.TRUNK)
public class TransferMoneyAgentTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String AGENCY_LOGIN_AGENT = FinanceLogins.AGENCY_TMONEY_AGENT2;
    private static final String CLIENT_LOGIN1 = FinanceLogins.TMONEY_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static float sumForCreate = 3000f;
    private static Money sumForTransfer = Money.valueOf(1000f);

    //Перевод между кампаниями, созданными разными представителями одного агентства
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6518")
    public void transferMoneyBetweenCampaignWithDifferentAgentOneAgencyRequestFromAgency() {
        log.info("Перевод между двумя кампаниями разных представителей одного агентства. Вызов под агентством");
        api.as(AGENCY_LOGIN).clientLogin(CLIENT_LOGIN1);
        long campaignIDFrom = api.userSteps.addActiveCampaign(sumForCreate, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        api.as(AGENCY_LOGIN_AGENT).clientLogin(CLIENT_LOGIN1);
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign();
        CampaignGetItem campaignFrom = api.userSteps.campaignSteps().getCampaign(campaignIDFrom);
        CampaignGetItem campaignTo = api.userSteps.campaignSteps().getCampaign(campaignIDTo);
        api.as(AGENCY_LOGIN).clientLogin(CLIENT_LOGIN1);
        api.userSteps.financeSteps()
                .transferMoney(campaignIDFrom, campaignIDTo, sumForTransfer.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom, sumForTransfer.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo, sumForTransfer));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6519")
    public void transferMoneyBetweenCampaignWithDifferentAgentOneAgencyRequestFromAgent() {
        log.info("Перевод между двумя кампаниями разных представителей одного агентства. Вызов под агентством");
        api.as(AGENCY_LOGIN).clientLogin(CLIENT_LOGIN1);
        long campaignIDFrom = api.userSteps.addActiveCampaign(sumForCreate, Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        api.as(AGENCY_LOGIN_AGENT).clientLogin(CLIENT_LOGIN1);
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign();
        CampaignGetItem campaignFrom = api.userSteps.campaignSteps().getCampaign(campaignIDFrom);
        CampaignGetItem campaignTo = api.userSteps.campaignSteps().getCampaign(campaignIDTo);
        api.userSteps.financeSteps()
                .transferMoney(campaignIDFrom, campaignIDTo, sumForTransfer.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom, sumForTransfer.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo, sumForTransfer));
    }
}
