package ru.yandex.autotests.directapi.finance.transfermoney;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 24.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
public class TransferMoneyCampaignsLimitTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = Logins.CLIENT_FOR_RUB;
    private static float sum = MoneyCurrency.get(Currency.RUB).getMinTransferAmount().addVAT().floatValue();
    private static final int CAMPAIGNS_LIMIT = 50;
    private static PayCampElementMap[] campaigns = new PayCampElementMap[CAMPAIGNS_LIMIT + 1];

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaigns() {
        for (int i = 0; i < CAMPAIGNS_LIMIT + 1; i++) {
            long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
            campaigns[i] = new PayCampElementMap(api.type())
                    .withCampaignID(campaignID)
                    .withCurrency(Currency.RUB)
                    .withSum(sum);
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6520")
    public void couldTransferMoneyToNotMoreThan50Campaigns() {
        long campaignIDFrom = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDFrom)
                                .withCurrency(Currency.RUB)
                                .withSum(sum * (CAMPAIGNS_LIMIT + 1)))
                        .withToCampaigns(campaigns),
                new AxisError(353, AxisErrorDetails.TRANSFER_NOT_POSSIBLE));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6521")
    public void couldTransferMoneyFromNotMoreThan50Campaigns() {
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(campaigns)
                        .withToCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDTo)
                                .withCurrency(Currency.RUB)
                                .withSum(sum * (CAMPAIGNS_LIMIT + 1))),
                new AxisError(353, AxisErrorDetails.TRANSFER_NOT_POSSIBLE));
    }
}
