package ru.yandex.autotests.directapi.finance.transfermoney;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 25.05.14
 * https://jira.yandex-team.ru/browse/TESTIRT-513
 */
@Aqua.Test
@Feature(FinanceFeatures.TRANSFER_MONEY)
@Stories(ApiStories.CURRENCY)
@RunWith(Parameterized.class)
public class TransferMoneyCompatibilityCampaignTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String rubServClient = Logins.LOGIN_FOR_RUB;
    private static String usdServClient = Logins.LOGIN_FOR_USD;
    private static String bynServClient = Logins.SERV_CLIENT_BYN;

    @Parameterized.Parameter(0)
    public String loginFrom;

    @Parameterized.Parameter(1)
    public String loginTo;

    @Parameterized.Parameters(name = "LoginFrom = {0}, LoginTo = {1}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {rubServClient, usdServClient},
                {rubServClient, bynServClient}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6522")
    public void expectErrorTransferMoneyBetweenDifferntCurrenciesCampaigns() {
        api.as(Logins.MANAGER_DEFAULT);
        long campaignIDFrom = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(loginFrom);
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(loginTo);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(campaignIDFrom, campaignIDTo, 10f, Currency.RUB,
                new AxisError(245, AxisErrorDetails.DENIED_TRANSFER_MONEY_BETWEEN_CAMPAIGNS_WITH_DIFFERENT_CURRENCIES));
    }
}
