package ru.yandex.autotests.directapi.finance.transfermoney;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Author pavryabov
 * Date 25.05.14
 * https://jira.yandex-team.ru/browse/TESTIRT-513
 */
@Aqua.Test
@Feature(FinanceFeatures.TRANSFER_MONEY)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
public class TransferMoneyCurrencyFieldTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String rubClient = Logins.LOGIN_FOR_RUB;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6523")
    public void transferMoneyRUBClientRUBInRequest() {
        api.as(rubClient);
        long campaignIDFrom = api.userSteps.addActiveCampaign(3000f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        long campaignIDTo = api.userSteps.addModeratedCampaign();
        log.info("Вызываем метод TransferMoney для кампаний рублевого клиента с параметром Currency = RUB " +
                "в FromCampaigns и ToCampaigns");
        int response =
                api.userSteps.financeSteps().transferMoney(campaignIDFrom, campaignIDTo, 1000f, Currency.RUB);
        assertThat("Метод вернул ошибку", response, equalTo(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6527")
    public void expectErrorTransferMoneyRUBClientUSDInRequest() {
        api.as(rubClient);
        long campaignIDFrom = api.userSteps.addActiveCampaign(2000f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        long campaignIDTo = api.userSteps.addModeratedCampaign();
        log.info("Вызываем метод TransferMoney для кампаний рублевого клиента с параметром Currency = USD " +
                "в FromCampaigns и ToCampaigns");
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(campaignIDFrom, campaignIDTo, 10f, Currency.USD,
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.RUB));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6528")
    public void expectErrorTransferMoneyRUBClientRUBInFromNoCurrencyInTo() {
        api.as(rubClient);
        long campaignIDFrom = api.userSteps.addActiveCampaign(2000f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(campaignIDFrom));
        long campaignIDTo = api.userSteps.addModeratedCampaign();
        log.info("Вызываем метод TransferMoney для кампаний рублевого клиента с параметром Currency = RUB " +
                "в FromCampaigns и Currency = null в ToCampaigns");
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignIDFrom)
                                        .withSum(300f)
                                        .withCurrency(Currency.RUB)
                        )
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(campaignIDTo)
                                        .withSum(5.0f)
                                        .withCurrency(Currency.USD)
                        ),
                new AxisError(245, AxisErrorDetails.ALL_AMOUNTS_MUST_BE_IN_THE_SAME_CURRENCY));
    }
}
