package ru.yandex.autotests.directapi.finance.transfermoney;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 08.10.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-43114"),
        @Issue("https://st.yandex-team.ru/DIRECT-44180")
})
@Features(FinanceFeatures.TRANSFER_MONEY)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class TransferMoneyForNonTextCampaignNegativeTest {
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String CLIENT_LOGIN = FinanceLogins.TMONEY_CLIENT4;

    private static final float SUM_FOR_CREATE = 2000f;
    private static final float SUM_FOR_TRANSFER = 500f;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private long nonTextCampaignIDFrom;
    private long nonTextCampaignIDTo;
    private long textCampaignIDFrom;
    private long textCampaignIDTo;

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
        });
    }

    @Before
    public void createNonTextAndTextCampaigns() {
        nonTextCampaignIDFrom =
                api.userSteps.addActiveCampaign(CLIENT_LOGIN, SUM_FOR_CREATE, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2
                .until(api.userSteps.campaignSteps().campaignFundsChanged(CLIENT_LOGIN, nonTextCampaignIDFrom));

        nonTextCampaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);

        textCampaignIDFrom =
                api.userSteps.addActiveCampaign(CLIENT_LOGIN, SUM_FOR_CREATE, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2
                .until(api.userSteps.campaignSteps().campaignFundsChanged(CLIENT_LOGIN, nonTextCampaignIDFrom));

        textCampaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);

        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDFrom, type);
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDTo, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6549")
    public void transferFromNonTextToNonText() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaignIDFrom)
                                        .withSum(SUM_FOR_TRANSFER)
                                        .withCurrency(Currency.RUB))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaignIDTo)
                                        .withSum(SUM_FOR_TRANSFER)
                                        .withCurrency(Currency.RUB)),
                new AxisError(3500, AxisErrorDetails.THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT_WITH_CAMPAIGN,
                        nonTextCampaignIDFrom));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6550")
    public void transferFromNonTextToText() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaignIDFrom)
                                        .withSum(SUM_FOR_TRANSFER)
                                        .withCurrency(Currency.RUB))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(textCampaignIDTo)
                                        .withSum(SUM_FOR_TRANSFER)
                                        .withCurrency(Currency.RUB)),
                new AxisError(3500, AxisErrorDetails.THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT_WITH_CAMPAIGN,
                        nonTextCampaignIDFrom));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6551")
    public void transferFromTextToNonText() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(textCampaignIDFrom)
                                        .withSum(SUM_FOR_TRANSFER)
                                        .withCurrency(Currency.RUB))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaignIDTo)
                                        .withSum(SUM_FOR_TRANSFER)
                                        .withCurrency(Currency.RUB)),
                new AxisError(3500, AxisErrorDetails.THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT_WITH_CAMPAIGN,
                        nonTextCampaignIDTo));
    }
}
