package ru.yandex.autotests.directapi.finance.transfermoney;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-43114"),
        @Issue("https://st.yandex-team.ru/DIRECT-44180")
})
@Features(FinanceFeatures.TRANSFER_MONEY)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class TransferMoneyForNonTextCampaignTest {
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String CLIENT_LOGIN = FinanceLogins.TMONEY_CLIENT4;

    private static final Money SUM_FOR_CREATE = MoneyCurrency.get(Currency.RUB)
            .getMinTransferAmount().add(BigDecimal.valueOf(3000));
    private static final Money SUM_FOR_TRANSFER = MoneyCurrency.get(Currency.RUB)
            .getMinTransferAmount().add(BigDecimal.valueOf(10));

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long nonTextCampaignIDFrom;
    private long nonTextCampaignIDTo;
    private long textCampaignIDFrom;
    private long textCampaignIDTo;

    private int response;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    private CampaignGetItem nonTextCampaignInfoFrom;
    private CampaignGetItem nonTextCampaignInfoTo;
    private CampaignGetItem textCampaignInfoFrom;
    private CampaignGetItem textCampaignInfoTo;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList((Object[][]) new Object[][]{
                {CampaignsType.DYNAMIC},
                {CampaignsType.MCBANNER},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE},
                {CampaignsType.CPM_BANNER},
                {CampaignsType.CPM_DEALS},
        });
    }

    @Before
    public void createNonTextAndTextCampaigns() {
        nonTextCampaignIDFrom =
                api.userSteps.addActiveCampaign(CLIENT_LOGIN,
                        SUM_FOR_CREATE.addVAT().setScale(2, RoundingMode.HALF_UP).floatValue(),
                        Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2
                .until(api.userSteps.campaignSteps().campaignFundsChanged(CLIENT_LOGIN, nonTextCampaignIDFrom));
        nonTextCampaignInfoFrom = api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN, nonTextCampaignIDFrom);

        nonTextCampaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);
        nonTextCampaignInfoTo = api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN, nonTextCampaignIDTo);

        textCampaignIDFrom =
                api.userSteps.addActiveCampaign(CLIENT_LOGIN,
                        SUM_FOR_CREATE.addVAT().setScale(2, RoundingMode.HALF_UP).floatValue(),
                        Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2
                .until(api.userSteps.campaignSteps().campaignFundsChanged(CLIENT_LOGIN, textCampaignIDFrom));
        textCampaignInfoFrom = api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN, textCampaignIDFrom);

        textCampaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);
        textCampaignInfoTo = api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN, textCampaignIDTo);

        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDFrom, type);
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDTo, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6555")
    public void transferFromNonTextToNonText() {
        response =
                api.userSteps.financeSteps().transferMoney(
                        nonTextCampaignIDFrom,
                        nonTextCampaignIDTo,
                        SUM_FOR_TRANSFER.floatValue(),
                        Currency.RUB
                );
        assertThat("вызов успешен", response, equalTo(1));
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDFrom, CampaignsType.TEXT);
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDTo, CampaignsType.TEXT);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN, nonTextCampaignInfoFrom, SUM_FOR_TRANSFER.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN, nonTextCampaignInfoTo, SUM_FOR_TRANSFER));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6556")
    public void transferFromNonTextToText() {
        response =
                api.userSteps.financeSteps().transferMoney(
                        nonTextCampaignIDFrom,
                        textCampaignIDTo,
                        SUM_FOR_TRANSFER.floatValue(),
                        Currency.RUB
                );
        assertThat("вызов успешен", response, equalTo(1));
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDFrom, CampaignsType.TEXT);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN, nonTextCampaignInfoFrom, SUM_FOR_TRANSFER.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN, textCampaignInfoTo, SUM_FOR_TRANSFER));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6557")
    public void transferFromTextToNonText() {
        response =
                api.userSteps.financeSteps().transferMoney(
                        textCampaignIDFrom,
                        nonTextCampaignIDTo,
                        SUM_FOR_TRANSFER.floatValue(),
                        Currency.RUB
                );
        assertThat("вызов успешен", response, equalTo(1));
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignIDTo, CampaignsType.TEXT);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN, textCampaignInfoFrom, SUM_FOR_TRANSFER.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN, nonTextCampaignInfoTo, SUM_FOR_TRANSFER));
    }

}
