package ru.yandex.autotests.directapi.finance.transfermoney;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 30.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1452
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
public class TransferMoneyNegativeShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    public static String operatorFirstShard = Logins.AGENCY_YE_DEFAULT;
    public static String operatorSecondShard = Logins.AGENCY_SHARD_2;
    public static String clientFirstShard = Logins.API_SUBCLIENT;
    public static String clientSecondShard = Logins.SUBCLIENT_SHARD;
    public static long campaignIDFirstShard;
    public static long campaignIDSecondShard;
    public static Money sum;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        campaignIDFirstShard =
                api.as(operatorFirstShard).userSteps.campaignSteps().addDefaultTextCampaign(clientFirstShard);
        campaignIDSecondShard =
                api.as(operatorSecondShard).userSteps.campaignSteps().addDefaultTextCampaign(clientSecondShard);
        sum = MoneyCurrency.get(null).getMinTransferAmount();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6597")
    public void transferMoneyOperatorFirstShardTest() {
        api.as(operatorFirstShard).userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                campaignIDFirstShard, campaignIDSecondShard, sum.floatValue(), Currency.RUB,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6598")
    public void transferMoneyOperatorFirstShardReverseTest() {
        api.as(operatorFirstShard).userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                campaignIDSecondShard, campaignIDFirstShard, sum.floatValue(), Currency.RUB,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6599")
    public void transferMoneyOperatorSecondShardTest() {
        api.as(operatorSecondShard).userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                campaignIDFirstShard, campaignIDSecondShard, sum.floatValue(), Currency.RUB,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6600")
    public void transferMoneyOperatorSecondShardReverseTest() {
        api.as(operatorSecondShard).userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                campaignIDSecondShard, campaignIDFirstShard, sum.floatValue(), Currency.RUB,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
