package ru.yandex.autotests.directapi.finance.transfermoney;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 26.08.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
@Tag(TagDictionary.TRUNK)
public class  TransferMoneyNegativeTest {

    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String ACCOUNT_CLIENT_LOGIN1 = FinanceLogins.TMONEY_CLIENT0;
    private static final String ACCOUNT_CLIENT_LOGIN2 = FinanceLogins.TMONEY_CLIENT8;
    private static final String ACCOUNT_CLIENT_LOGIN3 = FinanceLogins.TMONEY_CLIENT9;
    private static final String CLIENT_LOGIN1 = FinanceLogins.TMONEY_CLIENT4;
    private static final String CLIENT_LOGIN2 = FinanceLogins.TMONEY_CLIENT5;
    private static final String NO_CURRENCY_CLIENT_LOGIN = FinanceLogins.TRANSFER_CLIENT_1;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static float sumForTransfer;
    @Rule
    public Trashman trasher = new Trashman(api);
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public TransferMoneyNegativeTest() {
        api.as(AGENCY_LOGIN);
    }

    @BeforeClass
    public static void getAccountId() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_TRANSFER_1);
        api.as(FinanceLogins.AGENCY_TRANSFER_1);
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(FinanceLogins.TRANSFER_CLIENT_1);
        api.userSteps.createAccount(FinanceLogins.TRANSFER_CLIENT_1);
        api.as(Logins.MANAGER_DEFAULT);
        Long campaignID = api.userSteps.addDraftCampaign(FinanceLogins.TRANSFER_CLIENT_1);
        api.userSteps.campaignFakeSteps().resetWalletCreateDate(campaignID);
        api.as(Logins.SUPER_LOGIN).userSteps.createAccountForFreeClient(FinanceLogins.TRANSFER_CLIENT_1);

        api.userSteps.clientFakeSteps().enableAgencyWallet(AGENCY_LOGIN);
        api.as(AGENCY_LOGIN);
        api.userSteps.createAccount(ACCOUNT_CLIENT_LOGIN1);
        api.userSteps.createAccount(ACCOUNT_CLIENT_LOGIN2);
        api.userSteps.createAccount(ACCOUNT_CLIENT_LOGIN3);

        sumForTransfer = 1500f;
        api.userSteps.balanceSteps().synchronizeWithBalance(
                ((Account) api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN1)).getAccountID());
        api.userSteps.balanceSteps().synchronizeWithBalance(
                ((Account) api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN2)).getAccountID());
        api.userSteps.balanceSteps().synchronizeWithBalance(
                ((Account) api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN3)).getAccountID());
    }

    //1 клиент

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6601")
    public void transferMoneyBetweenCampaignsClientWithAccount() {
        log.info("Перевод между двумя кампаниями одного и того же кошелька");
        long campaignIDFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(campaignIDFrom, campaignIDTo, sumForTransfer,
                Currency.RUB, new AxisError(353, AxisErrorDetails.TRANSFERMONEY_BETWEEN_CAMPAIGNS_OF_SAME_ACCOUNT));
    }

    //3 клиента

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6602")
    public void transferMoneyFromAccountToAccountAndCampaign() {
        log.info("Перевод между тремя кампаниями разных клиентов. " +
                "Кампания источник и одна из кампаний приемников привязаны к кошельку");
        long accountFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long accountTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN2);
        long campaignTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN1);
        TransferMoneyInfoMap transferMoneyInfoMap = new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(new PayCampElementMap(api.type())
                        .withCampaignID(accountFrom)
                        .withCurrency(Currency.RUB)
                        .withSum(2 * sumForTransfer))
                .withToCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(accountTo)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer),
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignTo)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer));
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(transferMoneyInfoMap,
                new AxisError(353, AxisErrorDetails.MONEY_TRANSFERS_TO_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6603")
    public void transferMoneyFromAccountAndCampaignToAccount() {
        log.info("Перевод между тремя кампаниями разных клиентов. " +
                "Кампания приемник и одна из кампаний источников привязаны к кошельку");
        long accountFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long campaignFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN1);
        long accountTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN2);
        TransferMoneyInfoMap transferMoneyInfoMap = new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(accountFrom)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer),
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignFrom)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer))
                .withToCampaigns(new PayCampElementMap(api.type())
                        .withCampaignID(accountTo)
                        .withCurrency(Currency.RUB)
                        .withSum(2 * sumForTransfer));
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(transferMoneyInfoMap,
                new AxisError(353, AxisErrorDetails.MONEY_TRANSFERS_FROM_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6604")
    public void transferMoneyFromAccountToTwoAccounts() {
        log.info("Перевод между тремя кампаниями разных клиентов. " +
                "Все кампании привязаны к кошелькам. Перевод с одной на две");
        long accountFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long accountTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN2);
        long accountToElse = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN3);
        TransferMoneyInfoMap transferMoneyInfoMap = new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(new PayCampElementMap(api.type())
                        .withCampaignID(accountFrom)
                        .withCurrency(Currency.RUB)
                        .withSum(2 * sumForTransfer))
                .withToCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(accountTo)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer),
                        new PayCampElementMap(api.type())
                                .withCampaignID(accountToElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer));
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(transferMoneyInfoMap,
                new AxisError(353, AxisErrorDetails.MONEY_TRANSFERS_TO_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6605")
    public void transferMoneyFromTwoAccountsToAccount() {
        log.info("Перевод между тремя кампаниями разных клиентов. " +
                "Все кампании привязаны к кошелькам. Перевод с двух на одну");
        long accountFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long accountFromElse = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN2);
        long accountTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN3);
        TransferMoneyInfoMap transferMoneyInfoMap = new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(accountFrom)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer),
                        new PayCampElementMap(api.type())
                                .withCampaignID(accountFromElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer))
                .withToCampaigns(new PayCampElementMap(api.type())
                        .withCampaignID(accountTo)
                        .withCurrency(Currency.RUB)
                        .withSum(2 * sumForTransfer));
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(transferMoneyInfoMap,
                new AxisError(353, AxisErrorDetails.MONEY_TRANSFERS_FROM_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6606")
    public void transferMoneyFromAccountToTwoCampaignsOfDifferentClients() {
        log.info("Перевод между тремя кампаниями разных клиентов. " +
                "Кампания источник привязана к кошельку");
        long accountFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long campaignTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN1);
        long campaignToElse = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN2);
        TransferMoneyInfoMap transferMoneyInfoMap = new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(new PayCampElementMap(api.type())
                        .withCampaignID(accountFrom)
                        .withCurrency(Currency.RUB)
                        .withSum(2 * sumForTransfer))
                .withToCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignTo)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer),
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignToElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer));
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(transferMoneyInfoMap,
                new AxisError(353, AxisErrorDetails.MONEY_TRANSFERS_TO_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6607")
    public void transferMoneyFromTwoCampaignsOfDifferentClientsToAccount() {
        log.info("Перевод между тремя кампаниями разных клиентов. " +
                "Кампания приемник привязана к кошельку");
        long campaignFrom = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN1);
        long campaignFromElse = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN2);
        long accountTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN3);
        TransferMoneyInfoMap transferMoneyInfoMap = new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignFrom)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer),
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignFromElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumForTransfer))
                .withToCampaigns(new PayCampElementMap(api.type())
                        .withCampaignID(accountTo)
                        .withCurrency(Currency.RUB)
                        .withSum(2 * sumForTransfer));
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(transferMoneyInfoMap,
                new AxisError(353, AxisErrorDetails.MONEY_TRANSFERS_FROM_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED));
    }

    //Перенос под менеджером между агентствами

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6613")
    public void transferMoneyFromServicedClientToAgencyClient() {
        log.info("Перевод между сервисируемой кампанией и агентской");
        api.as(AGENCY_LOGIN);
        long agencyAccount = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN1);
        api.as(MANAGER);
        long servicedAccount = api.userSteps.campaignSteps().addDefaultTextCampaign(NO_CURRENCY_CLIENT_LOGIN);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(servicedAccount, agencyAccount, sumForTransfer,
                Currency.RUB, new AxisError(353, AxisErrorDetails.TRANSFER_ONLY_WITHIN_THE_SAME_AGENCY));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6614")
    public void transferMoneyFromAgencyClientToServicedClient() {
        log.info("Перевод между агентской кампанией и сервисируемой");
        api.as(AGENCY_LOGIN);
        long agencyAccount = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN1);
        api.as(MANAGER);
        long servicedAccount = api.userSteps.campaignSteps().addDefaultTextCampaign(NO_CURRENCY_CLIENT_LOGIN);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(agencyAccount, servicedAccount, sumForTransfer,
                Currency.RUB, new AxisError(353, AxisErrorDetails.TRANSFER_ONLY_WITHIN_THE_SAME_AGENCY));
    }
}
