package ru.yandex.autotests.directapi.finance.transfermoney;

import java.math.RoundingMode;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;

/**
 * Author pavryabov
 * Date 28.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
public class TransferMoneyOperationLimitTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String CLIENT_LOGIN = Logins.CLIENT_FOR_RUB;

    private static final Integer OPERATION_NUMBER_LIMIT = 30;
    private static final Money TRANSFER_AMOUNT = MoneyCurrency.get(Currency.RUB).getMinTransferAmount();
    private static final Money INITIAL_SUM_FROM = Money.valueOf(200000L, Currency.RUB);

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long fromCampaignID;
    private static long toCampaignID1;
    private static long toCampaignID2;

    @BeforeClass
    public static void createCampaigns() {
        fromCampaignID = api.userSteps.addActiveCampaign(CLIENT_LOGIN, INITIAL_SUM_FROM.addVAT().floatValue(), Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(fromCampaignID));
        toCampaignID1 = api.userSteps.addModeratedCampaign(CLIENT_LOGIN);
        toCampaignID2 = api.userSteps.addActiveCampaign(CLIENT_LOGIN, 100000f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(toCampaignID2));

        Money sumFrom = INITIAL_SUM_FROM;
        Money sumTo = Money.valueOf(0L, Currency.RUB);
        for (int i = 1; i <= OPERATION_NUMBER_LIMIT; i++) {
            api.userSteps.financeSteps().transferMoney(new TransferMoneyInfoMap(api.type())
                    .withFromCampaigns(
                            new PayCampElementMap(api.type())
                                    .withCampaignID(fromCampaignID)
                                    .withCurrency(Currency.RUB)
                                    .withSum(TRANSFER_AMOUNT))
                    .withToCampaigns(
                            new PayCampElementMap(api.type())
                                    .withCampaignID(toCampaignID1)
                                    .withCurrency(Currency.RUB)
                                    .withSum(TRANSFER_AMOUNT)));
            sumFrom = sumFrom.subtract(TRANSFER_AMOUNT);
            sumTo = sumTo.add(TRANSFER_AMOUNT);
            ConditionFactories.NOTIFY_ORDER2.until(
                    api.userSteps.campaignSteps().campaignFundsSumIs(fromCampaignID), equalTo(sumFrom));
            ConditionFactories.NOTIFY_ORDER2.until(
                    api.userSteps.campaignSteps().campaignFundsSumIs(toCampaignID1), equalTo(sumTo));
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6616")
    public void transferFromCampaignMoreThanLimit() {
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps().getCampaign(fromCampaignID);
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps().getCampaign(toCampaignID2);

        api.userSteps.financeSteps().transferMoney(new TransferMoneyInfoMap(api.type())
                .withFromCampaigns(
                        new PayCampElementMap(api.type())
                                .withCampaignID(fromCampaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(TRANSFER_AMOUNT))
                .withToCampaigns(
                        new PayCampElementMap(api.type())
                                .withCampaignID(toCampaignID2)
                                .withCurrency(Currency.RUB)
                                .withSum(TRANSFER_AMOUNT)));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom,
                        TRANSFER_AMOUNT.setScale(2, RoundingMode.HALF_UP).negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo,
                        TRANSFER_AMOUNT.setScale(2, RoundingMode.HALF_UP)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6617")
    public void transferToCampaignMoreThanLimit() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(toCampaignID2)
                                        .withCurrency(Currency.RUB)
                                        .withSum(TRANSFER_AMOUNT))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(toCampaignID1)
                                        .withCurrency(Currency.RUB)
                                        .withSum(TRANSFER_AMOUNT)),
                new AxisError(56, AxisErrorDetails.REQUEST_LIMIT_EXCEEDED,
                        toCampaignID1, OPERATION_NUMBER_LIMIT, OPERATION_NUMBER_LIMIT, 1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6618")
    public void transferFromAndToCampaignsMoreThanLimit() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(fromCampaignID)
                                        .withCurrency(Currency.RUB)
                                        .withSum(TRANSFER_AMOUNT))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(toCampaignID1)
                                        .withCurrency(Currency.RUB)
                                        .withSum(TRANSFER_AMOUNT)),
                new AxisError(56, AxisErrorDetails.REQUEST_LIMIT_EXCEEDED,
                        toCampaignID1, OPERATION_NUMBER_LIMIT, OPERATION_NUMBER_LIMIT, 1));
    }
}
