package ru.yandex.autotests.directapi.finance.transfermoney;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 26.08.14
 */
@Aqua.Test
@Features(FinanceFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class TransferMoneyPaymentTokenTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static float sumForCreate = 2000f;
    private static Money sumForTransfer = Money.valueOf(300f);

    @Title("Bug DIRECT-41294")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6619")
    public void transferMoneyWithPaymentToken() {
        log.info("Перевод между двумя кампаниями одного клиента без кошелька. Авторизация по платежному токену");
        api.as(Logins.AGENCY_YE_DEFAULT);
        long campaignIDFrom =
                api.userSteps.addActiveCampaign(Logins.CLIENT_FREE_YE_DEFAULT, sumForCreate, null);

        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChanged(Logins.CLIENT_FREE_YE_DEFAULT, campaignIDFrom));
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(Logins.CLIENT_FREE_YE_DEFAULT);
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps().getCampaign(Logins.CLIENT_FREE_YE_DEFAULT, campaignIDFrom);
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps().getCampaign(Logins.CLIENT_FREE_YE_DEFAULT, campaignIDTo);
        api.userSteps.financeSteps().transferMoneyWithPaymentToken(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDFrom)
                                .withSum(sumForTransfer))
                        .withToCampaigns(new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDTo)
                                .withSum(sumForTransfer)));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(Logins.CLIENT_FREE_YE_DEFAULT, campaignFrom, sumForTransfer.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(Logins.CLIENT_FREE_YE_DEFAULT, campaignTo, sumForTransfer));
    }
}
