package ru.yandex.autotests.directapi.finance.transfermoney;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 30.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1452
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
@RunWith(Parameterized.class)
public class TransferMoneyPositiveShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String clientFirstShard;

    @Parameterized.Parameter(value = 2)
    public String clientSecondShard;

    @Parameterized.Parameter(value = 3)
    public Currency currency;

    @Parameterized.Parameters(name = "Operator = {0}, ClientFirstShard = {1}, ClientSecondShard = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.SUBCLIENT_SHARD_1, Logins.SUBCLIENT_SHARD, Currency.RUB},
        };
        return Arrays.asList(data);
    }

    public long campaignIDFirstShard;
    public CampaignGetItem campaignFirstShard;
    public long campaignIDSecondShard;
    public CampaignGetItem campaignSecondShard;
    public Money sum;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD_1, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void initTest() {
        api.as(Logins.SUPER_LOGIN, operator);
        sum = MoneyCurrency.get(currency).getMinTransferAmount();

        campaignIDFirstShard = api.userSteps.addActiveCampaign(
                clientFirstShard, sum.addVAT().multiply(2L).floatValue(), currency);
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChanged(clientFirstShard, campaignIDFirstShard));
        campaignFirstShard = api.userSteps.campaignSteps().getCampaign(clientFirstShard, campaignIDFirstShard);

        campaignIDSecondShard = api.userSteps.addActiveCampaign(
                clientSecondShard, sum.addVAT().multiply(2L).floatValue(), currency);
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChanged(clientSecondShard, campaignIDSecondShard));
        campaignSecondShard = api.userSteps.campaignSteps().getCampaign(clientSecondShard, campaignIDSecondShard);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6620")
    public void transferMoneyTest() {
        api.userSteps.financeSteps().transferMoney(
                campaignIDFirstShard, campaignIDSecondShard, sum.floatValue(), currency);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChangedOnFunds(
                clientFirstShard, campaignFirstShard, sum.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChangedOnFunds(
                clientSecondShard, campaignSecondShard, sum));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6621")
    public void transferMoneyReverseTest() {
        api.userSteps.financeSteps().transferMoney(
                campaignIDSecondShard, campaignIDFirstShard, sum.floatValue(), currency);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChangedOnFunds(
                clientFirstShard, campaignFirstShard, sum));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChangedOnFunds(
                clientSecondShard, campaignSecondShard, sum.negate()));
    }
}
