package ru.yandex.autotests.directapi.finance.transfermoney;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * User: ginger
 * Date: 02.07.13
 * <p/>
 * https://jira.yandex-team.ru/browse/TESTIRT-568
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
public class TransferMoneySameTypeOfClientsTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String ACCOUNT_CLIENT_LOGIN2 = FinanceLogins.TMONEY_CLIENT8;
    private static final String ACCOUNT_CLIENT_LOGIN3 = FinanceLogins.TMONEY_CLIENT9;
    private static final String CLIENT_LOGIN1 = FinanceLogins.TMONEY_CLIENT4;
    private static final String CLIENT_LOGIN2 = FinanceLogins.TMONEY_CLIENT5;

    private static final float SUM_FOR_CREATE = 6000f;
    private static final Money SUM_FOR_TRANSFER = Money.valueOf(1000L, Currency.RUB);

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void getAccountId() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(AGENCY_LOGIN);
        api.as(AGENCY_LOGIN).userSteps.createAccount(ACCOUNT_CLIENT_LOGIN2);
        api.userSteps.createAccount(ACCOUNT_CLIENT_LOGIN3);
        api.userSteps.financeSteps().verifyAccountExistsInBalance(ACCOUNT_CLIENT_LOGIN2);
        api.userSteps.balanceSteps().synchronizeWithBalance(
                ((Account) api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN2)).getAccountID());
        api.userSteps.financeSteps().verifyAccountExistsInBalance(ACCOUNT_CLIENT_LOGIN3);
        api.userSteps.balanceSteps().synchronizeWithBalance(
                ((Account) api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN3)).getAccountID());
    }

    public TransferMoneySameTypeOfClientsTest() {
        api.as(AGENCY_LOGIN);
    }

    //1 клиент

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6622")
    public void transferMoneyBetweenCampaignsClientNoAccount() {
        log.info("Перевод между двумя кампаниями одного клиента без кошелька");
        long campaignIDFrom = api.userSteps.addActiveCampaign(CLIENT_LOGIN1, SUM_FOR_CREATE, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChanged(CLIENT_LOGIN1, campaignIDFrom));
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN1);

        CampaignGetItem campaignFrom = api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN1, campaignIDFrom);
        CampaignGetItem campaignTo = api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN1, campaignIDTo);

        api.userSteps.financeSteps().transferMoney(
                campaignIDFrom, campaignIDTo, SUM_FOR_TRANSFER.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN1, campaignFrom, SUM_FOR_TRANSFER.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN1, campaignTo, SUM_FOR_TRANSFER));
    }

    //2 клиента

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6623")
    public void transferMoneyBetweenClientsWithAccounts() {
        log.info("Перевод между двумя кампаниями разных клиентов с кошельками");
        Account accountFrom = api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN3);
        long campaignIDFrom = api.userSteps.addActiveCampaign(ACCOUNT_CLIENT_LOGIN3, SUM_FOR_CREATE, Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.financeSteps().accountAmountChanged(accountFrom));
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(ACCOUNT_CLIENT_LOGIN2);
        accountFrom = api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN3);
        Account accountTo = api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN2);

        Money fromBefore = api.userSteps.financeSteps().getAccountAmount(accountFrom.getAccountID());
        Money toBefore = api.userSteps.financeSteps().getAccountAmount(accountTo.getAccountID());
        api.userSteps.financeSteps().transferMoney(
                campaignIDFrom, campaignIDTo, SUM_FOR_TRANSFER.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.financeSteps().accountAmountChangedOnSum(
                        accountFrom.getAccountID(), fromBefore, SUM_FOR_TRANSFER.negate()));
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.financeSteps().accountAmountChangedOnSum(
                        accountTo.getAccountID(), toBefore, SUM_FOR_TRANSFER));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6624")
    public void transferMoneyBetweenClientsNoAccounts() {
        log.info("Перевод между двумя кампаниями разных клиентов без кошельков");
        long campaignIDFrom = api.userSteps.addActiveCampaign(CLIENT_LOGIN1, SUM_FOR_CREATE, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(
                api.userSteps.campaignSteps().campaignFundsChanged(CLIENT_LOGIN1, campaignIDFrom));
        long campaignIDTo = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN2);
        CampaignGetItem campaignFrom =
                api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN1, campaignIDFrom);
        CampaignGetItem campaignTo =
                api.userSteps.campaignSteps().getCampaign(CLIENT_LOGIN2, campaignIDTo);

        api.userSteps.financeSteps().transferMoney(
                campaignIDFrom, campaignIDTo, SUM_FOR_TRANSFER.floatValue(), Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN1, campaignFrom, SUM_FOR_TRANSFER.negate()));

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(CLIENT_LOGIN2, campaignTo, SUM_FOR_TRANSFER));
    }
}
