package ru.yandex.autotests.directapi.finance.transfermoney;

import java.math.RoundingMode;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author pavryabov
 * Date 28.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.TRANSFER_MONEY)
public class TransferMoneyWrongRestTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long activeCampaignID;
    private static long stoppedCampaignID;
    private static float rest = MoneyCurrency.get(Currency.RUB).getMinTransferAmount().floatValue();

    @BeforeClass
    public static void createCampaigns() {
        activeCampaignID = api.userSteps.addActiveCampaign(clientLogin, 3000f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(activeCampaignID));
        stoppedCampaignID = api.userSteps.addActiveCampaign(clientLogin, 3000f, Currency.RUB);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(stoppedCampaignID));
        api.userSteps.campaignFakeSteps().setCampaignSum(stoppedCampaignID, rest);
        api.userSteps.campaignFakeSteps().makeCampaignStopped(stoppedCampaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6633")
    public void transferAllFromStoppedTest() {
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(stoppedCampaignID)
                                        .withCurrency(Currency.RUB)
                                        .withSum(rest))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(activeCampaignID)
                                        .withCurrency(Currency.RUB)
                                        .withSum(rest)),
                new AxisError(353, AxisErrorDetails.TRANSFERMONEY_INVALID_REMAINING_FUNDS, 0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6634")
    public void transferAllRoundedFromStoppedTest() {
        float sum = Money.valueOf(rest).setScale(RoundingMode.HALF_UP).floatValue();
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(stoppedCampaignID)
                                        .withCurrency(Currency.RUB)
                                        .withSum(sum))
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(activeCampaignID)
                                        .withCurrency(Currency.RUB)
                                        .withSum(sum)),
                new AxisError(353, AxisErrorDetails.TRANSFERMONEY_INVALID_REMAINING_FUNDS, 0));
    }
}
