package ru.yandex.autotests.directapi.finance.transfermoney;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.TransferMoneyInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

public class TransferMoneyYFTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String RUB_CLIENT = Logins.LOGIN_FOR_RUB;
    private static final String USD_CLIENT = Logins.LOGIN_FOR_USD;

    @Test
    public void transferMoneyNoCurrencyTest() {
        api.as(RUB_CLIENT);
        Money sum = Money.valueOf(600f);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(1234)
                                        .withSum(sum.floatValue())
                        )
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(4321)
                                        .withSum(sum.floatValue())
                        ),
                new AxisError(245));
    }

    @Test
    public void transferMoneyYndFixedTest() {
        api.as(USD_CLIENT);
        Money sum = Money.valueOf(600f);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(1234)
                                        .withCurrency(Currency.YND_FIXED)
                                        .withSum(sum.floatValue())
                        )
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(4321)
                                        .withCurrency(Currency.YND_FIXED)
                                        .withSum(sum.floatValue())
                        ),
                new AxisError(245));
    }

    @Test
    public void transferMoneyFromUsdToYndFixedTest() {
        api.as(USD_CLIENT);
        Money sum = Money.valueOf(600f);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(1234)
                                        .withCurrency(Currency.USD)
                                        .withSum(sum.floatValue())
                        )
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(4321)
                                        .withCurrency(Currency.YND_FIXED)
                                        .withSum(sum.floatValue())
                        ),
                new AxisError(245));
    }

    @Test
    public void transferMoneyFromYndFixedToUsdTest() {
        api.as(USD_CLIENT);
        Money sum = Money.valueOf(600f);
        api.userSteps.financeSteps().shouldGetErrorOnTransferMoney(
                new TransferMoneyInfoMap(api.type())
                        .withFromCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(1234)
                                        .withCurrency(Currency.YND_FIXED)
                                        .withSum(sum.floatValue())
                        )
                        .withToCampaigns(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(4321)
                                        .withCurrency(Currency.USD)
                                        .withSum(sum.floatValue())
                        ),
                new AxisError(245));
    }
}
