package ru.yandex.autotests.directapi.images.adimage;

import java.util.Arrays;
import java.util.Collection;

import org.json.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsImageType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.AdImageUpload;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Image;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.images.ImageLogins;
import ru.yandex.autotests.directapi.images.ImagesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.images.AdImageURLMap;
import ru.yandex.autotests.directapi.model.images.AdImageUploadMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEqualsAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;


/**
 * Created by ginger on 15.01.16.
 * https://st.yandex-team.ru/TESTIRT-8018
 */
@Aqua.Test
@Feature(ImagesFeatures.AD_IMAGE_UPLOAD)
@Issue("https://st.yandex-team.ru/DIRECT-49536")
@Description("проверка корректной записи в базу форматов и типа картинки")
@RunWith(Parameterized.class)
public class BannerImagesFormatDBTest {
    private static JSONObject expectedSmallFormats;
    private static JSONObject expectedRegularFormats;
    private static JSONObject expectedWideFormats;

    static String login = ImageLogins.LOGIN_CHECK_UPLOAD_STATUS_9;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String name;

    @Parameterized.Parameter(value = 1)
    public String url;

    @Parameterized.Parameter(value = 2)
    public BannerImagesFormatsImageType expectedImageType;

    @Parameterized.Parameter(value = 3)
    public JSONObject expectedImageFormats;

    private int[] taskIDs;
    private BannerImagesFormatsRecord bannerImagesFormatsData;

    @Parameterized.Parameters(name = "{0}")
    public static Collection roles() {
        api.as(Logins.SUPER_LOGIN).userSteps.imagesSteps().adImageDeleteForLogin(login);

        Image rx160 = new Image().withHeight(213).withHeight(160);
        Image rx180 = new Image().withHeight(240).withWidth(180);
        Image rx450 = new Image().withHeight(600).withWidth(450);
        Image rx80 = new Image().withHeight(107).withWidth(80);
        Image rx90 = new Image().withHeight(120).withWidth(90);
        Image ry110 = new Image().withHeight(110).withWidth(83);
        Image ry129 = new Image().withHeight(129).withWidth(97);
        Image ry150 = new Image().withHeight(150).withWidth(113);
        Image ry160 = new Image().withHeight(160).withWidth(120);
        Image ry180 = new Image().withHeight(180).withWidth(135);
        Image ry300 = new Image().withHeight(300).withWidth(225);
        Image ry450 = new Image().withHeight(450).withWidth(338);
        Image ry65 = new Image().withHeight(65).withWidth(49);
        Image ry80 = new Image().withHeight(80).withWidth(60);
        Image ry90 = new Image().withHeight(90).withWidth(68);

        expectedRegularFormats = new JSONObject()
                .put("x160", rx160)
                .put("x180", rx180)
                .put("x450", rx450)
                .put("x80", rx80)
                .put("x90", rx90)
                .put("y110", ry110)
                .put("y129", ry129)
                .put("y150", ry150)
                .put("y160", ry160)
                .put("y180", ry180)
                .put("y300", ry300)
                .put("y450", ry450)
                .put("y65", ry65)
                .put("y80", ry80)
                .put("y90", ry90);


        Image wx1080 = new Image().withHeight(607).withHeight(1080);
        Image wx300 = new Image().withHeight(169).withWidth(300);
        Image wx600 = new Image().withHeight(337).withWidth(600);
        Image wy150 = new Image().withHeight(150).withWidth(267);
        Image wy300 = new Image().withHeight(300).withWidth(533);

        expectedWideFormats = new JSONObject()
                .put("wx1080", wx1080)
                .put("wx300", wx300)
                .put("wx600", wx600)
                .put("wy150", wy150)
                .put("wy300", wy300);

        Object[][] data = new Object[][]{
                {ImagesSteps.nameValidRegularImages.get(1), ImagesSteps.getDefaultImageUrl(1, ImageType.REGULAR),
                        BannerImagesFormatsImageType.regular, expectedRegularFormats},
                {ImagesSteps.nameValidWideImages.get(1), ImagesSteps.getDefaultImageUrl(1, ImageType.WIDE),
                        BannerImagesFormatsImageType.wide, expectedWideFormats}
        };
        return Arrays.asList(data);
    }

    @Before
    public void uploadImage() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        try {
            taskIDs = api.as(login).userSteps.imagesSteps().putImageInUploadQueue(
                    new AdImageURLMap<>(api.type())
                            .withLogin(login)
                            .withURL(url)
                            .withName(name));

        } catch (Exception e) {
            throw new DirectAPIException("Ошибка при закгрузке картинок с URL", e);
        }

        Object[] images = api.userSteps.imagesSteps().waitForImageHandleResult(login, taskIDs[0]);
        AdImageUpload image = (AdImageUpload) new AdImageUploadMap(images[0]).getBean();

        bannerImagesFormatsData = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login)
                .imagesSteps().getBannerImagesFormatsRecords(image.getAdImageHash());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8878")
    public void checkImageType() {
        assertThat("в базе верный image_type", bannerImagesFormatsData.getImageType(),
                equalTo(expectedImageType));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8879")
    public void checkFormats() {
        assertThat("в базе верный formats", new JSONObject(bannerImagesFormatsData.getFormats()),
                beanDiffer(expectedImageFormats));
    }
}
